static const char file_id[] = "CGCUpSample.pl";
// .cc file generated from CGCUpSample.pl by ptlang
/*
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "KnownBlock.h"
#include "CGCUpSample.h"

const char *star_nm_CGCUpSample = "CGCUpSample";

const char* CGCUpSample :: className() const {return star_nm_CGCUpSample;}

Block* CGCUpSample :: makeNew() const { LOG_NEW; return new CGCUpSample;}

CodeBlock CGCUpSample :: sendOne (
"	$ref2(output,ix) = $ref(input);\n"
);

CodeBlock CGCUpSample :: sendAll (
"	int i;\n"
"	for (int i = 0; i < $val(factor); i++) {\n"
"		$ref2(output,i) = $val(fill);\n"
"	}\n"
"	$ref2(output,ix) = $ref(input);\n"
);

CGCUpSample::CGCUpSample ()
{
	setDescriptor("Upsample by a factor (default 2), filling with fill (default 0.0).  The\n\"phase\" tells where to put the sample in an output block.  The default\nis to output it first (phase = 0). The maximum phase is \"factor\" - 1.");
	addPort(input.setPort("input",this,FLOAT));
	addPort(output.setPort("output",this,FLOAT));
	addState(factor.setState("factor",this,"2","Number of samples produced."));
	addState(phase.setState("phase",this,"0","Where to put the input in the output block."));
	addState(fill.setState("fill",this,"0.0","Value to fill the output block."));
	addState(ix.setState("ix",this,"0","ix",
# line 48 "CGCUpSample.pl"
A_NONSETTABLE));

# line 56 "CGCUpSample.pl"
noInternalState();
}

void CGCUpSample::setup() {
# line 51 "CGCUpSample.pl"
output.setSDFParams(int(factor),int(factor)-1);
		if (int(phase) >= int(factor))
			Error::abortRun(*this, ": phase must be < factor");
}

void CGCUpSample::go() {
# line 69 "CGCUpSample.pl"
ix = int(factor) - int(phase) - 1;
		if (output.staticBuf() && output.linearBuf())
			addCode(sendOne);
		else
			addCode(sendAll);
}

// prototype instance for known block list
static CGCUpSample proto;
static KnownBlock entry(proto,"UpSample");
