static const char file_id[] = "../../../../src/domains/cgc/stars/CGCRectToPolar.pl";
// .cc file generated from ../../../../src/domains/cgc/stars/CGCRectToPolar.pl by ptlang
/*
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "KnownBlock.h"
#include "CGCRectToPolar.h"

const char *star_nm_CGCRectToPolar = "CGCRectToPolar";

const char* CGCRectToPolar :: className() const {return star_nm_CGCRectToPolar;}

Block* CGCRectToPolar :: makeNew() const { LOG_NEW; return new CGCRectToPolar;}

CodeBlock CGCRectToPolar :: body (
"	double xpart, ypart, m;\n"
"	xpart = $ref(x);\n"
"	ypart = $ref(y);\n"
"	m = sqrt(xpart*xpart + ypart*ypart);\n"
"	$ref(magnitude) = m;\n"
"	if (m == 0) $ref(phase) = 0;\n"
"	else $ref(phase) = atan2(ypart,xpart);\n"
);

CGCRectToPolar::CGCRectToPolar ()
{
	setDescriptor("Convert two numbers to magnitude and phase.\nThe phase output is in the range -PI to PI.");
	addPort(x.setPort("x",this,FLOAT));
	addPort(y.setPort("y",this,FLOAT));
	addPort(magnitude.setPort("magnitude",this,FLOAT));
	addPort(phase.setPort("phase",this,FLOAT));

# line 34 "../../../../src/domains/cgc/stars/CGCRectToPolar.pl"
noInternalState();
}

void CGCRectToPolar::setup() {
# line 37 "../../../../src/domains/cgc/stars/CGCRectToPolar.pl"
addInclude("<math.h>");
}

void CGCRectToPolar::go() {
# line 50 "../../../../src/domains/cgc/stars/CGCRectToPolar.pl"
addCode(body);
}

// prototype instance for known block list
static CGCRectToPolar proto;
static KnownBlock entry(proto,"RectToPolar");
