defstar
{
    name { PCMwrite }
    derivedFrom { PCM }
    domain { CGC }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
    desc {
Convert input to mu-law PCM and write it to a file.
The file can be the audio port /dev/audio, if supported by the workstation.
    }
    version { @(#)CGCPCMwrite.pl	1.3 11/25/92 }
    author { T. M. Parks }

    input
    {
	name { input }
	type { float }
    }

    codeblock (openFile)
    {
	/* Open file for writing. */
	if (! ($starSymbol(stream) = fopen("$val(fileName)","w")))
	{
		perror("$val(fileName)");
		exit(1);
	}
    }

    codeblock (noOpen)
    {
	/* Use standard output for writing. */
	$starSymbol(stream) = stdout;
    }

    codeblock (noClose)
    {
	/* Flush standard output. */
	if (fflush(stdout) != 0)
	{
	    perror("$val(fileName)");
	    exit(1);
	}
    }

    codeblock (convert)
    {
	/* Convert from floating point [-1.0,1.0) to mu-law PCM. */
	{
	    int exponent, mantissa, magnitude;

	    magnitude = fabs($ref(input)) * 4080.0;
	    for(exponent = 0; exponent < 7; exponent++)
		if ($sharedSymbol(PCM,offset)[exponent+1] > magnitude) break;
	    mantissa = ((magnitude - $sharedSymbol(PCM,offset)[exponent]) >> exponent) & 0xf;
	    exponent <<= 4;
	    $starSymbol(byte) = ~(exponent | mantissa) & 0x7f;
	    if (!signbit($ref(input))) $starSymbol(byte) |= 0x80;
	}
    }
    codeblock (write)
    {
	/* Write data to file. */
	fwrite(&$starSymbol(byte),1,1,$starSymbol(stream));
    }

    initCode
    {
	CGCPCM::initCode();
	if (standardIO)
	{
	    addCode(noOpen);
	}
	else
	{
	    addCode(openFile);
	}
    }

    go
    {
	addCode(convert);
	addCode(write);
    }

    wrapup
    {
	if (standardIO)
	    addCode(noClose);
	else
	    addCode(closeFile);
    }
}
