static const char file_id[] = "../../../../src/domains/cgc/stars/CGCPCMwrite.pl";
// .cc file generated from ../../../../src/domains/cgc/stars/CGCPCMwrite.pl by ptlang
/*
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "KnownBlock.h"
#include "CGCPCMwrite.h"

const char *star_nm_CGCPCMwrite = "CGCPCMwrite";

const char* CGCPCMwrite :: className() const {return star_nm_CGCPCMwrite;}

Block* CGCPCMwrite :: makeNew() const { LOG_NEW; return new CGCPCMwrite;}

CodeBlock CGCPCMwrite :: openFile (
"	/* Open file for writing. */\n"
"	if (! ($starSymbol(stream) = fopen(\"$val(fileName)\",\"w\")))\n"
"	{\n"
"		perror(\"$val(fileName)\");\n"
"		exit(1);\n"
"	}\n"
);

CodeBlock CGCPCMwrite :: noOpen (
"	/* Use standard output for writing. */\n"
"	$starSymbol(stream) = stdout;\n"
);

CodeBlock CGCPCMwrite :: noClose (
"	/* Flush standard output. */\n"
"	if (fflush(stdout) != 0)\n"
"	{\n"
"	    perror(\"$val(fileName)\");\n"
"	    exit(1);\n"
"	}\n"
);

CodeBlock CGCPCMwrite :: convert (
"	/* Convert from floating point [-1.0,1.0) to mu-law PCM. */\n"
"	{\n"
"	    int exponent, mantissa, magnitude;\n"
"\n"
"	    magnitude = fabs($ref(input)) * 4080.0;\n"
"	    for(exponent = 0; exponent < 7; exponent++)\n"
"		if ($sharedSymbol(PCM,offset)[exponent+1] > magnitude) break;\n"
"	    mantissa = ((magnitude - $sharedSymbol(PCM,offset)[exponent]) >> exponent) & 0xf;\n"
"	    exponent <<= 4;\n"
"	    $starSymbol(byte) = ~(exponent | mantissa) & 0x7f;\n"
"	    if (!signbit($ref(input))) $starSymbol(byte) |= 0x80;\n"
"	}\n"
);

CodeBlock CGCPCMwrite :: write (
"	/* Write data to file. */\n"
"	fwrite(&$starSymbol(byte),1,1,$starSymbol(stream));\n"
);

CGCPCMwrite::CGCPCMwrite ()
{
	setDescriptor("Convert input to mu-law PCM and write it to a file.\nThe file can be the audio port /dev/audio, if supported by the workstation.");
	addPort(input.setPort("input",this,FLOAT));


}

void CGCPCMwrite::wrapup() {
# line 93 "../../../../src/domains/cgc/stars/CGCPCMwrite.pl"
if (standardIO)
	    addCode(noClose);
	else
	    addCode(closeFile);
}

void CGCPCMwrite::initCode() {
# line 74 "../../../../src/domains/cgc/stars/CGCPCMwrite.pl"
CGCPCM::initCode();
	if (standardIO)
	{
	    addCode(noOpen);
	}
	else
	{
	    addCode(openFile);
	}
}

void CGCPCMwrite::go() {
# line 87 "../../../../src/domains/cgc/stars/CGCPCMwrite.pl"
addCode(convert);
	addCode(write);
}

// prototype instance for known block list
static CGCPCMwrite proto;
static KnownBlock entry(proto,"PCMwrite");
