defstar
{
    name { PCMread }
    derivedFrom { PCM }
    domain { CGC }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
    desc {
Read mu-law PCM from a file and convert to linear floating point.
The file can be the audio port /dev/audio, if supported by the workstation.
    }
    version { @(#)CGCPCMread.pl	1.3 11/25/92 }
    author { T. M. Parks }

    output
    {
	name { output }
	type { float }
    }

    codeblock (openFile)
    {
	/* Open file for reading. */
	if (! ($starSymbol(stream) = fopen("$val(fileName)","r")))
	{
		perror("$val(fileName)");
		exit(1);
	}
    }

    codeblock (noOpen)
    {
	/* Use standard input for reading. */
	$starSymbol(stream) = stdin;
    }

    codeblock (convert)
    {
	/* Convert from mu-law PCM to floating point [-1.0,1.0). */
	{
	    int exponent, mantissa, magnitude;

	    $starSymbol(byte) = ~$starSymbol(byte);
	    exponent = ($starSymbol(byte) >> 4) & 0x7;
	    mantissa = $starSymbol(byte) & 0xf;
	    magnitude = $sharedSymbol(PCM,offset)[exponent] + (mantissa << exponent);
	    $ref(output) = magnitude / 4080.0;
	    if ($starSymbol(byte) & 0x80) $ref(output) = -$ref(output);
	}
    }

    codeblock (read)
    {
	/* Read data from file. */
	if (!fread(&$starSymbol(byte),1,1,$starSymbol(stream)))
	{
	    perror("$val(fileName)");
	    exit(1);
	}
    }

    initCode
    {
	CGCPCM::initCode();
	if (standardIO)
	{
	    addCode(noOpen);
	}
	else
	{
	    addCode(openFile);
	}
    }

    go
    {
	addCode(read);
	addCode(convert);
    }

    wrapup
    {
	if (!standardIO)
	    addCode(closeFile);
    }
}
