static const char file_id[] = "CGCLMS.pl";
// .cc file generated from CGCLMS.pl by ptlang
/*
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "KnownBlock.h"
#include "CGCLMS.h"

const char *star_nm_CGCLMS = "CGCLMS";

const char* CGCLMS :: className() const {return star_nm_CGCLMS;}

Block* CGCLMS :: makeNew() const { LOG_NEW; return new CGCLMS;}

CodeBlock CGCLMS :: update (
"	int ix;\n"
"	/* First update the taps */\n"
"	double e = $ref(error);\n"
"	int index = $val(errorDelay)*$val(decimation) + $val(decimationPhase);\n"
"\n"
"	for (ix = 0; ix < $val(tapSize); ix++) {\n"
"		$ref2(taps,ix) = $ref2(taps,ix) +\n"
"			e * $ref2(signalIn,index) * $val(stepSize);\n"
"		index++;\n"
"	}\n"
);

CodeBlock CGCLMS :: save (
"    FILE* fp;\n"
"    int i;\n"
"    if (!(fp = fopen(saveFileName,\"w\"))) {\n"
"	/* File cannot be opened */\n"
"	fprintf(stderr,\"ERROR: Cannot open saveTapsFile for writing:\\n\");\n"
"    	exit(1);\n"
"    }\n"
"    for (i = 0; i < $val(tapSize); i++)\n"
"	fprintf(fp, \"%d %g\\n\", i, $ref2(taps,i));\n"
"    fclose(fp);\n"
);

CGCLMS::CGCLMS ()
{
	setDescriptor("Adaptive filter using LMS adaptation algorithm.\nInitial coefficients are in the \"taps\" state variable.\nDefault initial coefficients give an 8th order, linear phase\nlowpass filter.  To read default coefficients from a file,\nreplace the default coefficients with \"<fileName\".\nSupports decimation, but not interpolation.");
	addPort(error.setPort("error",this,FLOAT));
	addState(stepSize.setState("stepSize",this,"0.01","Adaptation step size."));
	addState(errorDelay.setState("errorDelay",this,"1","Delay in the update loop."));
	addState(saveTapsFile.setState("saveTapsFile",this,"","File to save final tap values."));

# line 66 "CGCLMS.pl"
// remove interpolation as a settable parameter
		interpolation.clearAttributes(A_SETTABLE);
		// taps are no longer constant
		taps.clearAttributes(A_CONSTANT);
}

void CGCLMS::wrapup() {
# line 107 "CGCLMS.pl"
const char* sf = saveTapsFile;
		if (sf != NULL && *sf != 0) {
			addCode("    {\n");
			addCode(save);
			addCode("    }\n");
		}
}

void CGCLMS::initCode() {
# line 85 "CGCLMS.pl"
addInclude("<stdio.h>");
}

void CGCLMS::setup() {
# line 72 "CGCLMS.pl"
// First check to be sure that interpolation is 1.
		interpolation = 1;

		// Next run the FIR setup routine
		CGCFIR :: setup();

		// Then reset the signalIn number of samples in the past
		// to account for the error delay.
		signalIn.setSDFParams(int(decimation),
				      int(decimation) + 1 + int(errorDelay)
				      + taps.size());
}

void CGCLMS::go() {
# line 88 "CGCLMS.pl"
addCode(bodyDecl);	// from FIR
		addCode(update);
		addCode(body);		// from FIR
}

// prototype instance for known block list
static CGCLMS proto;
static KnownBlock entry(proto,"LMS");
