static const char file_id[] = "../../../../src/domains/cgc/stars/CGCIIDUniform.pl";
// .cc file generated from ../../../../src/domains/cgc/stars/CGCIIDUniform.pl by ptlang
/*
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "KnownBlock.h"
#include "CGCIIDUniform.h"

const char *star_nm_CGCIIDUniform = "CGCIIDUniform";

const char* CGCIIDUniform :: className() const {return star_nm_CGCIIDUniform;}

Block* CGCIIDUniform :: makeNew() const { LOG_NEW; return new CGCIIDUniform;}

CodeBlock CGCIIDUniform :: initSeed (
"    srand48($val(seed));\n"
);

CodeBlock CGCIIDUniform :: random (
"		float scale = $val(upper) - ($val(lower));\n"
"		float center = ($val(upper) + ($val(lower)))/2.0;\n"
"		$ref(output) = scale * (drand48() - 0.5) + center;\n"
);

CGCIIDUniform::CGCIIDUniform ()
{
	setDescriptor("Generate pseudo-IID-uniform random variables.  The values range from\n-range to range where range is a parameter.");
	addPort(output.setPort("output",this,FLOAT));
	addState(lower.setState("lower",this,"0.0","lower limit of uniform random number generator"));
	addState(upper.setState("upper",this,"1.0","upper limit of uniform random number generator"));
	addState(seed.setState("seed",this,"1","seed"));


}

void CGCIIDUniform::initCode() {
# line 44 "../../../../src/domains/cgc/stars/CGCIIDUniform.pl"
addGlobal("double drand48();\n", "drand48");
		addCode(initSeed);
}

void CGCIIDUniform::go() {
# line 48 "../../../../src/domains/cgc/stars/CGCIIDUniform.pl"
addCode(random);
}

// prototype instance for known block list
static CGCIIDUniform proto;
static KnownBlock entry(proto,"IIDUniform");
