static const char file_id[] = "CGCDistributor.pl";
// .cc file generated from CGCDistributor.pl by ptlang
/*
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "KnownBlock.h"
#include "CGCDistributor.h"

const char *star_nm_CGCDistributor = "CGCDistributor";

const char* CGCDistributor :: className() const {return star_nm_CGCDistributor;}

Block* CGCDistributor :: makeNew() const { LOG_NEW; return new CGCDistributor;}

CGCDistributor::CGCDistributor ()
{
	setDescriptor("Takes one input stream and synchronously splits it into N output streams,\nwhere N is the number of outputs.  It consumes N*B input particles,\nwhere B = blockSize, and sends the first B particles to the first output,\nthe next B particles to the next output, etc.");
	addPort(input.setPort("input",this,ANYTYPE));
	addPort(output.setPort("output",this,ANYTYPE));
	output.inheritTypeFrom(input);
	addState(blockSize.setState("blockSize",this,"1","Number of particles in a block."));
	addState(ix.setState("ix",this,"1","index for multiple output trace",
# line 38 "CGCDistributor.pl"
A_NONSETTABLE|A_NONCONSTANT));


}

void CGCDistributor::setup() {
# line 41 "CGCDistributor.pl"
int n = output.numberPorts();
		input.setSDFParams(n*int(blockSize),n*int(blockSize)-1);
		output.setSDFParams(int(blockSize),int(blockSize)-1);
}

void CGCDistributor::go() {
# line 47 "CGCDistributor.pl"
StringList out;
		if(int(blockSize) > 1) out << "\tint j;\n";
		for (int i = output.numberPorts() - 1; i >= 0; i--) {
		   ix = output.numberPorts() - i;
		   if(int(blockSize) > 1) {
			out << "\tfor (j = ";
			out << int(blockSize)-1;
			out << "; j >= 0; j--)\n";
			out << "\t\t$ref2(output#ix,j) = $ref2(input,j+";
			out << i*int(blockSize);
		   } else {
			out << "\t$ref2(output#ix,0) = $ref2(input,";
			out << i;
		   }
		   out << ");\n";
		   addCode(out);
		   out.initialize();
		}
}

// prototype instance for known block list
static CGCDistributor proto;
static KnownBlock entry(proto,"Distributor");
