static const char file_id[] = "CGCDB.pl";
// .cc file generated from CGCDB.pl by ptlang
/*
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "KnownBlock.h"
#include "CGCDB.h"

const char *star_nm_CGCDB = "CGCDB";

const char* CGCDB :: className() const {return star_nm_CGCDB;}

Block* CGCDB :: makeNew() const { LOG_NEW; return new CGCDB;}

CodeBlock CGCDB :: body (
"	double f = $ref(input);\n"
"	if (f <= 0.0) $ref(output) = $val(min);\n"
"	else {\n"
"		f = $val(gain) * log10 (f);\n"
"		if (f < $val(min)) f = $val(min);\n"
"		$ref(output) = f;\n"
"	}\n"
);

CGCDB::CGCDB ()
{
	setDescriptor("Converts input to dB.  Zero and negative values are\nconverted to \"min\" (default -100).");
	addPort(input.setPort("input",this,FLOAT));
	addPort(output.setPort("output",this,FLOAT));
	addState(min.setState("min",this,"-100","Minimum output value."));
	addState(inputIsPower.setState("inputIsPower",this,"FALSE","TRUE if input is a power measurement, FALSE if it's an amplitude measurement."));
	addState(gain.setState("gain",this,"20.0","gain",
# line 51 "CGCDB.pl"
A_NONSETTABLE));

# line 54 "CGCDB.pl"
noInternalState();
}

void CGCDB::setup() {
# line 57 "CGCDB.pl"
if (int(inputIsPower)) gain=10.0;
		addInclude("<math.h>");
}

void CGCDB::go() {
# line 70 "CGCDB.pl"
addCode(body);
}

// prototype instance for known block list
static CGCDB proto;
static KnownBlock entry(proto,"DB");
