defstar {
	name { WriteFile }
	domain { CG96 }
	desc {
When run on the simulator, arranges for its input to be logged to a file.
	}
	version { @(#)CG96WriteFile.pl	1.8 12/1/92 }
	author { Chih-Tsung Huang }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 io library }
	explanation {
This star relies on a feature of the Sim96Target and uses them as commands for the simulator.
	}
	execTime {
		return 2;
	}
	input {
		name {input}
		type {float}
	}
	state {
		name { fileName }
		type { STRING }
		default { "outfile" }
		desc { 'Root' of filename that gets the data. '.sim' is appended.}
	}
	state {
		name { outVal}
		type { float }
		attributes { A_NONCONSTANT|A_NONSETTABLE|A_YMEM|A_NOINIT }
		default { "0"}
	}

	codeblock (logOut) {
output $ref(outVal) $val(fileName).sim -RF
}

	// this codeblock produces code
	codeblock (copy) {
	move	$ref(input),d0.s
	move	d0.s,$ref(outVal)
	}
	initCode {
		addCode(logOut,"simulatorCmds");
	}
	go {
		addCode(copy);
	}
}



