defstar {
	name { WaveForm }
	domain { CG96 }
	desc {
A value of values is repeated at the ouput with period period, zero-padding
or tuncating to period if necessary.
Setting period to 0 (default) ouputs the value once.
The default value is 0.1 0.2 0.3 0.4.
        }
	version { @(#)CG96WaveForm.pl	1.12 12/8/92 }
	author { Chih-Tsung Huang }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 signal sources library }
        explanation {
You can get periodic signals with any period, and can halt a simulation
at the end of the given waveform.  The following table summarizes the
capabilities:
.TS
center, box;
l l l l.
haltAtEnd   periodic   period    operation
_
NO          YES        0         The period is the length of the waveform
NO          YES        N>0       The period is N
NO          NO         anything  Output the waveform once, then zeros
.TE
The first line of the table gives the default settings.
.PP
This star may be used to read a file by simply setting "value" to
something of the form "< filename".  The file will be read completely
and its contents stored in an array.  The size of the array is currently
limited to 20,000 samples.  

.IE "waveform from file"
.IE "reading from a file"
.IE "halting a simulation"
	}

        ccinclude { "Scheduler.h" }

        output {
		name { output }
		type { float }
	}
	state {
		name { value }
		type { floatarray }
                desc { One period of the output waveform. }
		default { "0.1 0.2 0.3 0.4" }
                attributes {A_NONCONSTANT|A_YMEM|A_CIRC}
	}
        state {
                name { haltAtEnd }
                type { int }
                default { "NO" }
                desc { Halt the run at the end of the given data. }
        }
        state {
                name { periodic }
                type { int }
                default { "YES" }
                desc { Output is periodic if "YES" (nonzero). }
        }
	state {
		name { period }
		type { int }
                desc { If greater than zero, gives the period of the waveform.}
		default { 0 }
	}
        state  {
                name { firstVal }
                type { float }
                default { 0.1 }
                desc { first value of value }
                attributes { A_NONCONSTANT|A_NONSETTABLE }
        }
        state {
		name { valueLen }
		type { int }
		desc { number of values in value. }
		default { 4 }
                attributes { A_NONCONSTANT|A_NONSETTABLE }
	}
        state {
                name { dataCirc }
                type { int }
                desc { pointer }
                default { 0 }
                attributes { A_NONCONSTANT|A_NONSETTABLE|A_YMEM|A_NOINIT }
        }

        codeblock (org) {
; initialization of DC block
        org     $ref(output)
        }
        codeblock (dc) {
        dc      $val(firstVal)
        }
        codeblock (orgp) {
        org     p:
        }

        codeblock(initDataCirc) {
; pointer to data value $fullname()
        org     $ref(dataCirc)
        dc      $addr(value)
        org     p:
        }

        codeblock(impulse) {
; output impulse
        fclr    d1      $ref(value),d0.s
        move    d0.s,$ref(output)
        move    d1.s,$ref(value)
        }
        codeblock(aperiodic) {
; output general aperiodic value
        move    $ref(dataCirc),r0
        move    #$val(valueLen)-1,m0
        fclr    d1      y:(r0),d0.s
        move    d1.s,y:(r0)+
        move    d0.s,$ref(output)
        move    r0,$ref(dataCirc)
        move    m7,m0
        }     
        codeblock(negative) {
        move    $ref(dataCirc),r0
        move    #$val(valueLen)-1,m0
        nop
        move    y:(r0)+,d0.s
        move    d0.s,$ref(output)
        move    r0,$ref(dataCirc)
        move    m7,m0
        }
      
        codeblock(positive) {
        move    $ref(dataCirc),r0
        move    #$val(period)-1,m0
        nop
        move    y:(r0)+,d0.s
        move    d0.s,$ref(output)
        move    r0,$ref(dataCirc)
        move    m7,m0     
        }
	setup {
		firstVal = value[0];
		valueLen = value.size();

                if (int(haltAtEnd)) {
			Error::abortRun(*this,
				": haltAtEnd = YES not currently supported.");
			return;
		}
                if (!(int (haltAtEnd)) && int (periodic) && period == 0) {
			if (valueLen == 1)
				period = 1;
			else
	                        period = -1;
		}
                if (!(int (haltAtEnd)) && !(int (periodic)))
                        period = 0;
		if (int (period) <= 0)
			value.resize(int (valueLen));
		else
			value.resize(int (period));
	}
	initCode {
		if (period == 1) {
			//special case, reproduce DC star.
				addCode(org);
			for (int i = 0; i < output.bufSize(); i++)
				addCode(dc);
			addCode(orgp);
		} else
			addCode(initDataCirc);
	}
	go {
//  Not currently supported
//                if (int(haltAtEnd))
//                        Scheduler::requestHalt();
		if (period == 1)
			return;
		//special case, output stored at compile time.
			else if (period == 0) {
			if (valueLen == 1)
				addCode(impulse);
			//output impulse.
				else
				addCode(aperiodic);
			//output general aperiodic value.
		} else {
			//output periodic value-- use first period values.
				if (period == -1)
				addCode(negative);
			else
				addCode(positive);
		}
	}

	execTime {
		if (int (period) == 0)
			if (int (valueLen) == 1)
				return 4;
			else
				return 7;
		if (int (period) == 1)
			return 0;
		return 7;

	}
}


