defstar {
	name { UpSample }
	domain { CG96 }
	desc { Upsampling star	}
	version { @(#)CG96UpSample.pl	1.8 12/8/92 }
	author { Chih-Tsung Huang }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 control library }
	explanation {
Upsample by a factor (default 2), filling with fill (default 0.0).  The
"phase" tells where to put the sample in an output block.  The default
is to output it first (phase = 0). The maximum phase is "factor" - 1.
	}
	input {
		name {input}
		type {anytype}
	}
	output {
		name {output}
		type {=input}
	}
	state {
		name {factor}
		type {int}
		default {2}
		desc { Number of samples produced. }
		attributes { A_SETTABLE }
	}
	state {
		name {phase}
		type {int}
		default {0}
		desc { Where to put the input in the output block. }
		attributes { A_SETTABLE }
	}
	state {
		name {fill}
		type {float}
		default {0.0}
		desc { Value to fill the output block. }
		attributes { A_SETTABLE }
	}
	setup {
		output.setSDFParams(int(factor),int(factor)-1);
		if (int(phase) >= int(factor))
			Error::abortRun(*this, ": phase must be < factor");
	}
	codeblock (initfill) {
; initialization code for star $fullname() - class CG56UpSample
	move	#$addr(output),r1
	move	#$val(fill),d0.s
	}
	codeblock (repeatcode) {
	rep	#$size(output)
	}
	codeblock (fillcode) {
	move	d0.s,x:(r1)+
	}
	initCode {
		addCode (initfill);
		if (factor > 1) addCode(repeatcode);
		addCode(fillcode);
	}
	codeblock (sendsample) {
	move	$ref(input),d1.s
	move	d1.s,$ref2(output,phase)
	}
	go {
		addCode(sendsample);
	}
	execTime {
		return 1;
	}
}
