defstar {
	name { Tone }
	domain { CG96 }
	desc { Sine or cosine function using second order oscillator }
	version { @(#)CG96Tone.pl	1.8 12/8/92 }
	author { Chih-Tsung Huang }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 signal sources library }
	output {
		name { output }
		type { float }
	}
	state {
		name { amplitude }
		type { float }
		desc { amplitude of sine/cosine wave }
		default { .5 }
	}
	state {
		name { frequency }
		type { float }
		desc { frequency, relative to the sampling frequency }
		default { .02 }
	}
	state {
		name { calcType }
		type { string }
		desc { calculation type (sin or cos) }
		default { "sin" }
	}
	state {
		name { state1 }
		type { float }
		desc { internal }
		default { 0 }
		attributes { A_NONCONSTANT|A_NONSETTABLE|A_YMEM }
	}
	state {
		name { state2 }
		type { float }
		desc { internal }
		default { 0 }
		attributes { A_NONCONSTANT|A_NONSETTABLE|A_XMEM }
	}
	state {
		name { X }
		type { float }
		desc { internal }
		default { 0 }
		attributes { A_NONCONSTANT|A_NONSETTABLE}
	}
	setup {
		// maximum value
		const double maxFix = 1.0 - 1.0/double(1 << 23);
		double twoPiF = 2.0 * M_PI * double(frequency);
		X = cos(twoPiF);
		if (double(X) > maxFix) X = maxFix;
		const char* p = calcType;
		switch (*p) {
		case 's':	// sine
			state1 = 0.0;
			state2 = double(amplitude) * sin(twoPiF);
			break;
		case 'c':	// cosine
			state1 = double(amplitude);
			state2 = double(amplitude) * cos(twoPiF);
			break;
		default:
			Error::abortRun(*this, "calcType must be sin or cos");
			return;
		}
	}

	go { addCode(std); }

	execTime { return 11;}

	codeblock (std) {
	move	$ref(state2),d2.s
	move	$ref(state1),d1.s
	move	#$val(X),d0.s
        move    d1.s,$ref(state2)
        fmpy.s  d2,d0,d3        d2.s,$ref(output)
        fadd.s  d3,d3           d2.s,$ref(state1)
        fsub.s  d1,d3
        move    d3.s,$ref(state2)
        }

}
