defstar {
	name { Tan }
	domain { CG96 }
	desc { Tangent function }
	version { @(#)CG96Tan.pl	1.5 12/1/92 }
	author { Chih-Tsung Huang }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 nonlinear functions library }
	explanation {
.PP
This star computes the tangent of the input.
.PP
The star computes the tangent of the input
by computing the ratio of the sine and the cosine
of the input using the lookup table in memory
locations X:$400-$7FF and Y:$400-$7FF of the DSP96002.
Linear interpolation between values in the table is used.
If the cosine value is 0, +/- 1e10 will be output.
        }    

        seealso { Sin, Cos }
	input {
		name { input }
		type { float }
 	}
	output {
		name { output }
		type { float }
	}

        codeblock(main) {
; set up table access, where the table starts at location $400
        move    #$$400,n0
        move    #162.9746617,d1.s
        ori     #8,omr
; get input and scale to create table index
        move    $ref(input),d0.s
        fmpy.s  d1,d0,d0        #$$000003ff,d7.l
; truncate to get integer index
        floor   d0,d1
        int     d1 d1.s,d2.s
; do linear interpolation
        fsub.s  d2,d0
        and     d7.l,d1.l
        fclr    d6.s    d1.l,r0
        move    #1.0,d4.s
        move    (r0)+n0
        move    x:(r0)+,d3.s    y:,d5.s
        cmp     d7.l,d1.l
        jeq     $label(label)
        move    x:(r0),d4.s     y:,d6.s
$label(label)
        fsub.s  d3,d4
        fsub.s  d5,d6
        fmpy.s  d0,d4,d4
        fmpy.s  d0,d6,d6
        fadd.s  d3,d4
        fadd.s  d5,d6
        ftst    d4.s
        jeq     $label(coszero)
; cosine is not zero
        fseedd  d4,d7
        fmpy.s  d4,d7,d4        #2.0,d5.s
        fsub.s  d4,d5           d5.s,d3.s
        fmpy.s  d4,d5,d4
        fmpy    d7,d5,d2                fsub.s d4,d3
        fmpy.s  d2,d3,d4
        fmpy.s  d4,d6,d1
        jmp     $label(endTest)
$label(coszero)
        ftst    d6.s
        jpl     $label(yneg)
        move    #1e10,d1.s
        jmp     $label(endTest)
$label(yneg)
        move    #-1e10,d1.s
$label(endTest)
        move    d1.s,$ref(output)
        andi    #$$f7,omr
        }    

	go {
                addCode(main);
	}
	execTime {
                return 41;
       }
}
