defstar {
	name { Sub }
	domain { CG96 }
	desc { any input subtractor }
	version { @(#)CG96Sub.pl	1.7 12/1/92 }
	author { Chih-Tsung Huang }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 arithmetic library }
	explanation {
.PP
Output the \fIpos\fR minus all \fIneg\fR inputs.
        }    
	input {
		name { pos }
		type { float }
 	}
	inmulti {
		name { neg }
		type { float }
 	}
	output {
		name { output }
		type { float }
	}
        state  {
                name { inputNum }
                type { int }
                default { 0 }
                desc { input#() }
                attributes { A_NONCONSTANT|A_NONSETTABLE }
        }
        codeblock(main) {
        move    $ref(pos),d0.s
        }
        codeblock(loop) {
        move    $ref(neg#inputNum),d4.s    
        fsub.s  d4,d0
        }
        codeblock(done) {
        move    d0.s,$ref(output)
        }

	go {
                addCode(main);
                for (int i = 1; i <= neg.numberPorts(); i++) {
                        inputNum=i;
                        addCode(loop);
                }
                addCode(done);
	}
	execTime {
                return 2*int(neg.numberPorts()) +2;
       }
}
