defstar {
	name { Sin }
	domain { CG96 }
	desc { Sine function }
	version { @(#)CG96Sin.pl	1.6 12/1/92 }
	author { Chih-Tsung Huang, ported from Gabriel }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 nonlinear functions library }
	explanation {
.PP
This star computes the sine of the input.
The output is in the range (-1.0, 1.0).
.PP
The star computes the sine using the lookup table in memory
locations Y:$400-$7FF of the DSP96002.
Linear interpolation between values in the table is used.
        }    

        seealso { Cos }
	input {
		name { input }
		type { float }
 	}
	output {
		name { output }
		type { float }
	}

        codeblock(main) {
; set up table access, where the table starts at location $$400
        move    #$$400,n0
        move    #162.9746617,d1.s
        ori     #8,omr
; get input and scale to create table index
        move    $ref(input),d0.s
        fmpy.s  d1,d0,d0 #$$000003ff,d7.l
        floor   d0,d1
        int     d1 d1.s,d2.s
; do linear interpolation
        fsub.s  d2,d0
        and     d7.l,d1.l
        move    d1.l,r0
        fclr    d4.s
        move    (r0)+n0
        cmp     d7.l,d1.l y:(r0)+,d3.s
        jeq     $label(jump)
        move    y:(r0),d4.s
$label(jump)
        fsub.s  d3,d4
        fmpy.s  d0,d4,d4
        fadd.s  d3,d4
        move    d4.s,$ref(output)
        andi    #$$f7,omr
        }    

	go {
                addCode(main);
	}
	execTime {
                return 23;
       }
}
