defstar {
	name { Rect }
	domain { CG96 }
	desc { Rectangular Pulse Generator }
	version { @(#)CG96Rect.pl	1.9 12/8/92 }
	author { Chih-Tsung Huang }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 signal sources library }
	explanation {
Square wave generator.
	}
	output {
		name {output}
		type {float}
	}
        state {
                name {height}
	        type {float}
	        desc { height of rectangular pulse. }
	        default { 1.0 }
        }
        state {
                name {width}
	        type {int}
	        desc { width of rectangular pulse. }
	        default { 1 }
        }
        state {
                name {period}
	        type {int}
	        desc { period of pulse }
	        default { 10 }
        }
        state {
                name {periodCounter}
                type {int}
	        desc { internal }
	        default { 0 }
                attributes {A_YMEM|A_NONCONSTANT|A_NONSETTABLE}
        }
        state {
                name {durationCounter}
	        type {int}
	        desc { internal }
	        default { 0 }
                attributes {A_YMEM|A_NONCONSTANT|A_NONSETTABLE}
        }
        state {
                name {amp}
	        type {float}
	        desc { internal }
	        default { 0 }
                attributes {A_YMEM|A_NONCONSTANT|A_NONSETTABLE}
        }

        codeblock(main) {
        move    $ref(durationCounter),d0.l
        move	#$val(width),d1.l
        cmp	d0.l,d1.l
        jneq	<$label(val)
        move	$ref(periodCounter),d0.l
        move    #$val(period)-1,d1.l
        cmp     d0.l,d1.l
        jeq	<$label(restart)
        inc	d0.l
        move	d0.l,$ref(periodCounter)
        jmp	<$label(zero)
$label(val)
        inc	d0.l
 	move	d0.l,$ref(durationCounter)
        move    $ref(periodCounter),d1.l
        inc     d1.l
        move	d1.l,$ref(periodCounter)
        move    $ref(amp),d0.s
        move    d0.s,$ref(output)
        jmp     <$label(end)
$label(restart)
        clr	d0.l
        move	d0.l,$ref(durationCounter)
        move    d0.l,$ref(periodCounter)
$label(zero)
        fclr    d0
        move    d0.s,$ref(output)
$label(end)
        }

        setup {
		 int w=width;
		 int p=period;
		 amp=height;

		 if(w<1) 
		     Error::abortRun(*this, "Invalid width value.");
		 if(p<1)    
		     Error::abortRun(*this, "Invalid period value.");
		 if(p<=w)
		     Error::abortRun(*this, "Period must be greater than width");
        }			      
	go {
                addCode(main);
	}
	execTime {
		return 20;
	}

}
