defstar {
	name { Ramp }
	domain { CG96 }
	desc {
Generates a ramp signal, starting at "value" (default 0.0)
with step size "step" (default 1).
	}
	version {@(#)CG96Ramp.pl	1.8 12/8/92}
	author { Chih-Tsung Huang }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 signal sources library }
	output {
		name { output }
		type { float }
	}
	state {
		name { step }
		type { float }
		default { 1 }
		desc { Increment from one sample to the next. }
	}
	state {
		name { value }
		type { float }
		default { 0.0 }
		desc { Initial (or latest) value output by Ramp. }
		attributes { A_SETTABLE|A_NONCONSTANT }
	}
        state {
                name {sum}
                type {float}
                default {0}
                desc { An internal state.}
                attributes { A_NONSETTABLE|A_YMEM|A_NONCONSTANT }
	}

        codeblock (main) {
	move	$ref(sum),d0.s
	move	#$val(step),d1.s
        move    d0.s,$ref(output)
	fadd.s	d1.s,d0.s
        move    d0.s,$ref(sum)
	}
	
	setup {
		sum=value;
	}
	go {
		addCode(main);
	}
        execTime {
		return 5;
	}
}
