defstar {
	name { Mpy }
	domain { CG96 }
	desc { Multipy any number of inputs, producing an output. }
	version { @(#)CG96Mpy.pl	1.6 12/1/92 }
	author { Chih-Tsung Huang }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 arithmetic library }
	explanation {
The inputs are multiplied and the result is written on the output.
	}
	inmulti {
		name {input}
		type {float}
	}
	output {
		name {output}
		type {float}
	}
        state  {
                name { inputNum }
                type { int }
                default { 0 }
                desc { input#() }
                attributes { A_NONCONSTANT|A_NONSETTABLE }
        }
	codeblock (std) {
	move	$ref(input#1),d4.s
        move	$ref(input#2),d6.s
	}
	codeblock (sat) {
	fmpy.s	d4,d6,d0
	move	d0.s,$ref(output)	
	}
	codeblock (one) {
	move	$ref(input#1),d0.s
	move	d0.s,$ref(output)
	}
        codeblock(loop) {
        fmpy.s  d4,d6,d0     $ref(input#inputNum),d4.s
	move    d0.s,d6.s
        }

	go {
		if (input.numberPorts() == 1) {
			addCode(one);
			return;
		}
		addCode(std);
		for (int i = 3; i <= input.numberPorts(); i++) {
	                inputNum=i;
			addCode(loop);
		}
	        addCode(sat);
	}
	exectime {
		if (input.numberPorts() == 1) return 2;
		else return input.numberPorts() + 2;
	}
}
