defstar {
	name { Log }
	domain { CG96 }
	desc { Logrithm, out=log(in) }
	version { @(#)CG96Log.pl	1.8 12/1/92 }
	author { Chih-Tsung Huang (ported from Gabriel) }
        acknowledge { Gabriel version by Anthony Wong }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 nonlinear functions library }
	explanation {
.PP
This star computes the logarithm (default base = e)
of its input by first computing ln(x).
Floating-point evaluation of ln(x) can be performed by representing x
as s*(2^e) where s is the significand and e is the unbiased exponent.
Then ln(x) = 0.6931471 * log2(x),
where log2(x) = log2(s) + e.
For the significand s,
log2(s) can be evaluated with a polynomial.
By adding the unbiased exponent,
log2(x) results.
.PP
To get logarithm with base other than e,
set the \fIbase\fR parameter to the desired base.
.UH BUGS
Since log2(x) is evaluated anyway,
there should be an option where the user
can request log2(x) without having to set
the base.
	}
	execTime {
		return 33;
	}
	input {
		name {input}
		type {float}
	}
	output {
		name {output}
		type {float}
	}
        state {
                name {base}
	        type {float}
	        desc { base value }
	        default { 2.7182818284 }
	}
        state {
                name {constant}
	        type {floatarray}
	        desc { internal }
	        default {
"0.6681523e-02 -0.6736254e-01 0.2584541e+00 -0.3676691e+00 -0.4461204e+00 0.2740512e+01 -0.5236615e+01 0.6184454e+01 -0.3072334e+01"
              	}
                attributes {A_CONSTANT|A_NONSETTABLE|A_YMEM}
	}    
        state {
                name {X}
	        type {float}
	        desc { internal }
	        default { 0 }
                attributes {A_CONSTANT|A_NONSETTABLE}
	}    
	codeblock (expblock) {
        move    $ref(input),d0.s
        move    #$val(X),d3.s
        move    #<$addr(constant),r0
        getexp  d0,d7
        fgetman d0,d0
        fclr    d2      y:(r0)+,d1.s
        do      #9,$label(loop)
        fmpy.x  d2,d0,d2
        fadd.x  d1,d2   y:(r0)+,d1.s
$label(loop)
        float.x d7
        fadd.s  d7,d2   #0.69317418055,d0.s
        fmpy.s  d2,d0,d2
        fmpy.s  d2,d3,d2
        move    d2.s,$ref(output)
        }
    
	go {
                X=1.0/log(base);
		addCode(expblock);
	}
}
