defstar {
	name { Limit }
	domain { CG96 }
	desc { Limiter }
	version { @(#)CG96Limit.pl	1.7 12/1/92 }
	author { Chih-Tsung Huang }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 nonlinear functions library }
	explanation {
.PP
This star hard limits its input data to the range between
\fIbottom\fP and \fItop\fP.
Inputs between within these ranges are passed through unchanged.
        }    

        seealso { Sgn }
	input {
		name { input }
		type { float }
 	}
	output {
		name { output }
		type { float }
	}
 	state {
		name {bottom}
		type {float}
		default {"0.0"}
		desc {Lower limit of the output.}
	}
	state {
		name {top}
		type {float}
		default {"1.0"}
		desc {Upper limit of the output.}
	}

        codeblock(main) {
        move    #$val(top),d1.s
        move    $ref(input),d0.s
        fcmp    d1.s,d0.s
; If input exceeds top, jump
        jpl     $label(exceeded)
        move    #$val(bottom),d1.s
        fcmp    d1.s,d0.s
; If input is smaller than bottom, jump
        jmi     $label(exceeded)
        move    d0.s,d1.s
$label(exceeded)
        move    d1.s,$ref(output)
        }    
	go {
                addCode(main);

	}
	execTime {
                return 10;
        }
}
