defstar {
	name { Impulse }
	domain { CG96 }
	desc { Impulse generator }
	version { @(#)CG96Impulse.pl	1.8 12/1/92 }
	author { Chih-Tsung Huang, ported from Gabriel }
        acknowledge { Gabriel version by Anthony Wong }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 signal sources library }
        explanation {
.PP
The star produces at its output an impulse with height given by the parameter
\fIimpulseSize\fR.
.PP
A state variable is maintained to keep around the next output value.
At initialization, the state is set to \fIimpulseSize\fR.
During each subsequent invocation, the output value is taken from the state,
which is then set to zero.
        }
        seealso { WaveForm, DC }
        output {
		name { output }
		type { float }
	}
	state {
		name { impulseSize }
		type { float }
		desc { impulse size }
		default { 1.0 }
	}
 	state {
		name { pulse }
		type { floatarray }
		desc { internal }
		default { "0" }
		attributes { A_NONCONSTANT|A_NONSETTABLE|A_YMEM|A_NOINIT }
	}

        codeblock(initpulse) {
; initialize pulse  
        org     $ref(pulse)
        dc      $val(impulseSize)
        org     p:
        }
	codeblock(std) {
	fclr	d1	$ref(pulse),d0.s
	move	d0.s,$ref(output)
	move	d1.s,$ref(pulse)
	} 
        initCode {
               addCode(initpulse);
	}       
        go {
               addCode(std);
	}

	execTime { 
		return 3;
	}
 }
