defstar {
	name { IIDUniform }
	domain {CG96}
	desc { Random Noise Generator (uniform distribution) }
	version { @(#)CG96IIDUniform.pl	1.5 12/1/92 }
	author { Chih-Tsung Huang }
        acknowledge { Gabriel version by Anthony Wong }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 signal sources library }
	explanation {
.PP
This star generates a sequence of random output samples with a uniform
distribution.
The output values range from -\fIrange\fR to +\fIrange\fR.
.PP
The numbers are generated using a pseudorandom number generation technique.
A 32 bit seed is multiplied by a constant and then incremented.
The result is the output and also the seed for the next round.
	}
	output {
		name { output }
		type { float }
	}
	state {
		name { range }
		type { float }
		default { 0.5 }
		desc { range of random number generator is [-range,+range] }
	}
	state {
		name { initialSeed }
		type { float }
		default { 23571 }
		desc { initial value }
	}
	state {
		name { seed }
		type { float }
		default { 0 }
		attributes { A_XMEM|A_NOINIT|A_NONSETTABLE|A_NONCONSTANT}
	}
	initCode {
		addCode(initSeed);
	}
	go {
		addCode(random);
	}

	// "code" to initialize the seed
	codeblock(initSeed) {
	org	$ref(seed)
	dc	$val(initialSeed)
        org     p:
	}

	codeblock(random) {
; generate random 32-bit integer
        move    $ref(seed),d0.l
        move    #69069,d1.l
        mpyu    d0,d1,d0
        inc     d0
        move    d0.l,$ref(seed)
; convert to floating point number within (-range, +range)
        floatu.s       d0     #$val(range)*4.656613e-10,d2.s
        fmpy.s  d0,d2,d0      #>$val(range),d1.s
        fsub.s  d1,d0
        move    d0.s,$ref(output)
	}

	execTime {
		return 10;
	}
}



