defstar {
	name { IIDGaussian }
	domain { CG96 }
	desc { Gaussian Noise Source }
	version { @(#)CG96IIDGaussian.pl	1.7 12/1/92 }
	author { Chih-Tsung Huang }
        acknowledge { Gabriel version by Anthony Wong }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 signal sources library }
	explanation {
.PP
This star generates a sequence of zero-mean random output samples
with a Gaussian distribution (standard deviation = 1 by default)
.PP
According to the central limit theorem, the sum of N random variables
approaches a Gaussian distribution as N approaches infinity.
This star generates an output number by summing \fInoUniforms\fR uniform
random variables.
.PP
The parameters \fIinitialSeed\fR  controls the generation of the
random number.
        }
        seealso { IIDUniform }
	output {
		name {output}
		type {float}
	}
  
        state {
                name {noUniforms}
	        type {int}
	        desc { uniformity }
	        default { 10 }
        }
        state {
                name {variance}
	        type {float}
	        desc { variance }
	        default { 1 }
        }
        state {
                name {initialSeed}
	        type {float}
	        desc { initial value }
	        default { 23571 }
        }
        state {
                name {seed}
	        type {floatarray}
	        desc { internal }
	        default { "0" }
                attributes {A_XMEM|A_NONCONSTANT|A_NONSETTABLE|A_NOINIT}
        }
    
        state {
                name {shift}
	        type {float}
	        desc { internal }
	        default { 0 }
                attributes {A_NONCONSTANT|A_NONSETTABLE}
        }
        codeblock (initseed) {
; initialize seed 
        org     $ref(seed)
        dc      $val(initialSeed)
        org     p:
        }
	codeblock (block) {
        fclr    d3      #4.656613e-10,d2.s
        do      #$val(noUniforms),$label(more)
        move    $ref(seed),d0.l
        move    #69069,d1.l
        mpyu    d0,d1,d0
        inc     d0
        move    d0.l,$ref(seed)
        floatu.s        d0
        fmpy.s  d0,d2,d0
        fadd.s  d0,d3
$label(more)
        }
        codeblock(cont) {
        fsub.s  d1,d3
        move    #$val(shift),d1.s
        fmpy.s  d3,d1,d3
        move    d3.s,$ref(output)
	}
        initCode {
                addCode(initseed);
        }		
	go {
                shift = sqrt((3.0*double(variance))/double(noUniforms));
                double i = double(noUniforms);
          	addCode(block);
                char buf[80];
                sprintf (buf, "\tmove\t#%E,d1.s",i);
                addCode(CodeBlock(buf));
                addCode(cont);
	}
	execTime {
		return 11+9*(int(noUniforms));
	}

}
