defstar {
	name { Gain }
	domain { CG96 }
	desc {
The output is set to the input multiplied by a gain term.
}
	version { @(#)CG96Gain.pl	1.7 12/1/92 }
	author { Chih-Tsung Huang }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 arithmetic library }
	explanation {
The input is multiplied by a float gain factor and sent to the output.
	}
        seealso { Mpy }
	execTime {
		return double(gain) == 1.0 ? 2 : 4;
	}
	input {
		name {input}
		type {float}
	}
	output {
		name {output}
		type {float}
	}
	defstate {
		name {gain}
		type {float}
		default {2}
		desc {Gain value}
	}
	codeblock (std) {
	move	$ref(input),d4.s
	move	#$val(gain),d6.s
	fmpy.s	d4,d6,d0
	move	d0.s,$ref(output)
	}
	codeblock (unity) {
	move	$ref(input),d0.s
	move	d0.s,$ref(output)
	}
	go {
		if (double(gain) == 1.0) addCode(unity);
		else addCode(std);
	}
}
