defstar {
	name { FloatToFix }
	domain { CG96 }
	desc { Float to Fix number star }
	version { @(#)CG96FloatToFix.pl	1.9 12/1/92 }
	author { Chih-Tsung Huang }
        acknowledge { Gabriel version by Anthony Wong }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 conversion library }
	explanation {
.PP
The star converts a 32-bit IEEE single-precision format floating-point number
to a N-bit fix-point number for N <= 32.
The N-bit fix-point number is assumed to be
a two's complement number between -1 (inclusive) and +1 (exclusive).
The bits (sign bit included) for the fix-point number
should occupy the lowest N bits of a 32-bit word.
	}
        seealso { fixToFloat }
	input {
		name {input}
		type {float}
	}
	output {
		name {output}
		type {fix}
	}
        state {
                name {N}
	        type {int}
	        desc {N bit fix point }
	        default { 32 }
	}

	codeblock(defaultCB) {
        move    $ref(input),d0.s
        move    #>2147483648.0,d1.s
        fmpy.s  d0,d1,d0
        int     d0
        move    d0.l,$ref(output)
        }

        codeblock(less) {
        move    $ref(input),d0.s
        move    #>2147483648.0,d1.s
        fmpy.s  d0,d1,d0
        int     d0
        lsr     #>32-$val(N),d0.l
        move    d0.l,$ref(output)
	}

	go {
               if (N<32)
                 addCode(less);
	       else
	         addCode(defaultCB);
	}

	execTime {
                if(int(N)==32)
	    		return 8;
		else
	                return 10;
	}

}
