defstar {
	name { Delay }
	domain { CG96 }
	desc { A delay star of parameter totalDelay unit delays. }
	version { @(#)CG96Delay.pl	1.7 12/8/92 }
	author { Chih-Tsung Huang }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 control library }
        explanation {
A delay star of parameter totalDelay unit delays.
}

        input  {
                name { input }
	        type { float }
	}
        output {
		name { output }
		type { float }
	}
        state  {
                name { delayBuf }
		type { floatarray }
		desc { buffer }
		default { "0" }
                attributes {A_CIRC|A_NONCONSTANT|A_NONSETTABLE|A_YMEM|A_NOINIT}
        }
        state  {
                name { delayBufStart }
                type { int }
                default { 0 }
                desc { pointer to the buffer }
                attributes { A_NONCONSTANT|A_NONSETTABLE|A_YMEM|A_NOINIT }
        }
        state  {
                name { totalDelay }
	        type { int }
	        default { 10 }
	        desc { maximum delay }
         }
	codeblock(block) {
; initialize delay star
; pointer to internal buffer
	org	$ref(delayBufStart)
  	dc	$addr(delayBuf)
   	org 	p:
	}        		      

        codeblock(std) {
        move $ref(input),d5.s
        move $ref(delayBufStart),r0
        move #$val(totalDelay)-1,m0
        move y:(r0),d6.s
        move d5.s,y:(r0)+
        move r0,$ref(delayBufStart)
        move d6.s,$ref(output)
        move #-1,m0
        }
        setup {
                delayBuf.resize(totalDelay);
        }		
        initCode {
                addCode(block);
	}
        go {
                addCode(std);
        }		
	execTime { 
                 return 10;
	}
}
