defstar {
	name { Cos }
	domain { CG96 }
	desc { Cosine function }
	version { @(#)CG96Cos.pl	1.8 12/1/92 }
	author { Chih-Tsung Huang }
	acknowledge { Gabriel version by Anthony Wong }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 nonlinear functions library }
	explanation {
This star takes the cosine of the input using lookup tables.
	}
	execTime {
		return 24;
	}
	input {
		name {input}
		type {float}
	}
	output {
		name {output}
		type {float}
	}
	codeblock (cosblock) {
        move    #$$400,n0
        move    #162.9746617,d1.s
        ori     #8,omr
        move    $ref(input),d0.s
        fmpy.s  d1,d0,d0 #$$000003ff,d7.l
        floor   d0,d1
        int     d1 d1.s,d2.s
        fsub.s  d2,d0
        and     d7.l,d1.l
        move    d1.l,r0
        move    #1.0,d4.s
        move    (r0)+n0
        cmp     d7.l,d1.l x:(r0)+,d3.s
        jeq     $label(loop)
        move    x:(r0),dd4.s
$label(loop)
        fsub.s  d3,d4
        fmpy.s  d0,d4,d4
        fadd.s  d3,d4
        move    d4.s,$ref(output)
        andi    #$$f7,omr

	}
	go {
		addCode(cosblock);
	}
}
