defstar {
	name { Average }
	domain { CG96 }
	desc { Average of N numbers of input }
	version { @(#)CG96Average.pl	1.7 12/8/92 }
	author { Chih-Tsung Huang }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 control library }
	explanation {
Averages some number of input samples.
	}
	input {
		name {input}
		type {float}
	}
	output {
		name {output}
		type {float}
	}
        state  {
                name { numInputsToAverage }
                type { int }
                default { 10 }
                desc { N numbers to be averaged }
        }

	codeblock(main) {
        move    #<$addr(input),r0
        fclr    d1.s
        move    x:(r0)+,d0.s
        rep     #$val(numInputsToAverage)-1
        fadd.s  d0,d1   x:(r0)+,d0.s
        fadd.s  d0,d1
        move    #>1.00/$val(numInputsToAverage),d0.s
        fmpy.s  d0,d1,d0
        move    d0.s,$ref(output)
        }
        codeblock(other) {
        move    $ref(input),d0.s    
        move    d0.s,$ref(output)
        }
	setup {
		input.setSDFParams(int (numInputsToAverage),
		                   int (numInputsToAverage) - 1);
	}
	go {
		if (numInputsToAverage > 1)
			addCode(main);
		else
			addCode(other);
	}
	exectime {
		if (numInputsToAverage > 1)
			return 8 + int  (numInputsToAverage);
		else
			return 2;
	}
}
