defstar {
	name { ATan }
	domain { CG96 }
	desc { Arc tangent function }
	version { @(#)CG96ATan.pl	1.6 12/1/92 }
	author { Chih-Tsung Huang }
        acknowledge { Gabriel version by Anthony Wong }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 nonlinear functions library }
	explanation {
This star takes the arc tangent of the input.
 Algorithm - Phase(x,y) = A - z * (0.971899 - 0.191848 * z^2)

    if |in| < 1        then    z = -in                 A = 0
    if |in| >= 1       then    z = 1 / in      and
                               if  in >= 0     then    A = pi / 2
                               if  in < 0      then    A = -pi / 2
	}
	execTime {
		return 27;
	}
	input {
		name {input}
		type {float}
	}
	output {
		name {output}
		type {float}
	}
	codeblock (atanblock) {
        move    #1.0,d4.s
        move    $ref(input),d5.s
; Code to compute the principle arc-tangent
        fcmpm   d4,d5
        fjge    $label(zcomp)
        fclr    d2      d5.s,d3.s
        fneg.s  d3
        jmp     $label(zdone)
$label(zcomp)
        fseedd  d5,d6
        fmpy.s  d5,d6,d5        #2.0,d7.s
        fsub.s  d5,d7           d7.s,d3.s
        fmpy.s  d5,d7,d5
        fmpy    d6,d7,d2        fsub.s d5,d3
        fmpy.s  d2,d3,d3
        ftst    d3.s
        fjmi    $label(aneg)
        move    #1.5707963268,d2.s
        jmp     $label(zdone)
$label(aneg)
        move    #-1.5707963268,d2.s
$label(zdone)
        move    #0.971899,d6.s
        move    #-0.191848,d7.s
        fmpy.s  d3,d3,d1
        fmpy.s  d1,d7,d0
        fadd.s  d6,d0
        fmpy.s  d0,d3,d0
        fsub.s  d0,d2
        move    d2.s,$ref(output)
	}
	go {
		addCode(atanblock);
	}
}
