defstar {
	name {LevDur}
	domain {CG96}
	desc { Levinson-Durbin algorithm. }
	version {@(#)CG96LevDur.pl	1.9 12/8/92}
	author { Chih-Tsung Huang }
        acknowledge { Gabriel version by Anthony Wong }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 dsp library }
        explanation {
.PP
This star uses as inputs the autocorrelation series
calculated with the CG96CrossCorr star
and uses the Levinson-Durbin algorithm
to compute either the reflection ceofficients
or the FIR linear predictor coefficients.
If the \fIunbiased\fR paramter of the CG96CrossCorr star is set to "No",
then the combined effect of that star and this one
is called the autocorrelation algorithm.
The parameter \fIorder\fR should be set equal to
the parameter \fInoLags\fR in the CG96CrossCorr star.
The star expects inputs of the order:
r(0), r(1), ... , r(order).
The output \fBoutput\fR depends on the parameter \fImode\fR:
.IP
If \fImode\fR is set to 1,
the \fBoutput\fR output produces the reflection coefficients
k(1), k(2), ... , k(order).
This set of coefficients is sutibale for directly
feeding the CG96BlockLattice star
which accepts outside coefficients
and produces the forward and backward prediction error.
.IP
If \fImode\fR is set to 2,
the \fBoutput\fR output produces the FIR linear predictor coefficients
a(1), a(2), ... , a(order).
This set of coefficients is sutibale for directly
feeding the CG96BlockFir star
which accepts outside coefficients
and produces the forward prediction of the process.
.PP
In addition to the output \fBoutput\fR,
the star also produces the \fIorder\fRth prediction error power
on the output \fBerrPower\fR.
.PP
Note that the definition of reflection coefficients
is not quite universal in the literature.
The reflection coefficients generated by this star
are the negative of the ones corresponding to
the definition of partial-correlation (PARCOR)
coefficients in the statistics literature.
.UH REFERENCES
.IP [1]
S. M. Kay, \fIModern Spectral Estimation: Theory & Application\fR,
Prentice-Hall, Englewood Cliffs, NJ, 1988.
.IP [2]
S. Haykin, \fIModern Filters\fR, MacMillan Publishing Company,
New York, 1989.
	}
	input {
		name{autocor}
		type{float}
	}
	output {
		name{output}
		type{float}
	}
	output {
		name{errPower}
		type{float}
	}
	state {
		name {order}
		type {int}
		default {16}
		desc {
	        provides orderth prediction error power on the output power.
                }
	}
	state {
		name {mode}
		type {int}
		default {1}
		desc {
	              Mode 1 - autocorrelation -> reflection coef
                      Mode 2 - autocorrelation -> AR coef
                }
	}
        state {
                name {arCoef}
	        type {floatarray}
                desc {internal}
	        default {"0"}
	        attributes {
	        A_SYMMETRIC|A_RAM|A_NONCONSTANT|A_NONSETTABLE|A_NOINIT
	        }
        }
	setup {
		if (int(order) == 0) {
			Error::abortRun(*this,
			   ": Order must be >= 1 for this star.");
			return;
		}
		autocor.setSDFParams(int(order)+1,int(order));
		output.setSDFParams(int(order),int(order)-1);
                arCoef.resize(int(order)+1);
	}
        initCode {
                addCode(block);
	}	
        codeblock(block) {
; initialize the block of AR coefficients in $fullname()
        org     x:$addr(arCoef)+1
        bsc     $val(order)+1,0.0
        org     p:
        org     y:$addr(arCoef)
        bsc     1,1.0
        org     p:
        org     y:$addr(arCoef)+1
        bsc     $val(order),0.0
        org     p:
        }

        codeblock(main) {
        move    #<$addr(arCoef),r0
        move    #>$addr(autocor),r6
        move    #>$addr(output),r7
        lea     (r6)+,r4
; computation for order = 1
        move    x:(r6)+,d7.s
        move    x:(r6)+,d1.s    d7.s,d2.s
        fseedd  d2,d4
        fmpy.s  d2,d4,d2        #2.0,d5.s
        fsub.s  d2,d5           d5.s,d3.s
        fmpy.s  d2,d5,d2
        fmpy    d4,d5,d3        fsub.s d3,d2
        fmpy.s  d2,d3,d2
        fmpy.s  d2,d1,d0
        fmpy.s  d7,d0,d5        d0.s,d8.s
        fmpy.s  d5,d8,d5
        fsub.s  d5,d7
        }    
        codeblock(out) {
        move    d8.s,x:(r7)+
        }       
        codeblock(outpower) {
        move    d7.s,$ref(errPower)
        }       
        codeblock(orderTwo) {
; computation for order = 2
        fmpy.s  d1,d8,d2        x:(r6)+,d1.s
        fadd.s  d2,d1   d7.s,d2.s
        fseedd  d2,d4
        fmpy.s  d2,d4,d2        #2.0,d5.s
        fsub.s  d2,d5           d5.s,d3.s
        fmpy.s  d2,d5,d2
        fmpy    d4,d5,d3        fsub.s d3,d2
        fmpy.s  d2,d3,d2
        fmpy.s  d2,d1,d0        d8.s,d4.s
; compute P(2)
        fmpy.s  d7,d0,d5        d0.s,d8.s
        fmpy.s  d5,d8,d5
        fsub.s  d5,d7
; update AR coef.
        lea     (r0)+,r3
        fmpy.s  d0,d4,d2
        fadd.s  d4,d2
        move    d2.s,y:(r3)+
        move    d8.s,y:(r3)+
        }
        codeblock(two) {
        move    d2.s,x:(r7)+
        move    d0.s,x:(r7)+
        move    d7.s,$ref(errPower)
        }
        codeblock(three) {
; computation for order > 2
        move    #2,d6.l
        do      #$val(order)-2,$starSymbol(mainloop)
; first compute k(M)
; compute reflection coefficient
        move    d6.l,n4
        move    r0,r3
        lea     (r4)+n4,r5
        fclr    d2.s
        fclr    d1.s    x:(r5)-,d4.s    y:(r3)+,d5.s
        rep     d6.l
        fmpy    d4,d5,d2        fadd.s  d2,d1   x:(r5)-,d4.s    y:(r3)+,d5.s
        fmpy    d4,d5,d2        fadd.s  d2,d1
        fadd.s  d2,d1   d7.s,d2.s
        fseedd  d2,d4
        fmpy.s  d2,d4,d2        #2.0,d5.s
        fsub.s  d2,d5           d5.s,d3.s
        fmpy.s  d2,d5,d2
        fmpy    d4,d5,d3        fsub.s d3,d2
        fmpy.s  d2,d3,d2
        fmpy.s  d2,d1,d0
; compute P(M)
; compute predicton-error power
        fmpy.s  d7,d0,d5        d0.s,d8.s
        fmpy.s  d5,d8,d5        d6.l,n0
        fsub.s  d5,d7
; finally update a(M)
; Levinson-Durbin recursion
; copy AR coef in reverse order from Y memory to X memory
        lea     (r0)+n0,r1
        lea     (r0)+,r5
        move    y:(r1)-,d4.s
        rep     d6.l
        move    d4.s,x:(r5)+    y:(r1)-,d4.s
; update AR coefficients
        lea     (r0)+,r1
        lea     (r0)+,r5
        dec     d6.l    x:(r1),d5.s
        fmpy.s  d5,d8,d3        y:(r1)+,d4.s
        do      d6.l,$label(uploop)
        fadd.s  d4,d3   x:(r1)+,d5.s    y:,d4.s
        fmpy.s  d5,d8,d3        d3.s,y:(r5)+
$label(uploop)
        fadd.s  d4,d3
        inc     d6.l    d3.s,y:(r5)+
        move    d8.s,y:(r5)+
        }
        codeblock(threecont) {
        inc     d6.l
$starSymbol(mainloop)
        }
        codeblock(modeTwo) {
        move    y:(r0)+,d0.s
        do      #$val(order),$label(outloop)
        move    y:(r0)+,d0.s
        move    d0.s,x:(r7)+
$label(outloop)
        } 
        codeblock(powerout) {
        move    d7.s,$ref(errPower)
        }
 	go {

// Register Usage
//
// d6.l  Current order
// d7.s  Prediction Error Power
// d8.s  Reflection Coefficient

// r0    CONSTANT: points to head of AR coefficients (ar_coef)
// r4    CONSTANT: points to r(1)
// r6    points to input
// r7    points to output

                addCode(main);
		if(int(mode)==1 || int(order)==1) addCode(out);
		if(int(order)==1) addCode(outpower);
                if(int(order)>=2) {
	               addCode(orderTwo);
		       if(int(mode)==1) addCode(out);
		       if(int(order)==2 && int(mode)==2) addCode(two);
		}
	        if(int(order)>=3) {
	               addCode(three);
		       if(int(mode)==1) addCode(out);
		       addCode(threecont);
                } 
                if(int(mode)==2) addCode(modeTwo);
		addCode(powerout);
	}
        execTime {
         if(int(mode)==1) {
           if(int(order)==1) return 22;
	   else if(int(order)==2) return 40;
       	   else return 44+(int(order)-2)*(30+(2*int(order)*(int(order)-1)));
         }
         else if(int(mode)==2) {
             if(int(order)==1) return 26;
	     else if(int(order)==2) return 47;
             else return 49+(int(order)-2)*(31+(2*int(order)*(int(order)-1)));
         }
	 return 0;  // it never gets here!  it is just to avoid warning
        }
}

