defstar {
	name { IIR }
	domain { CG96 }
	desc { A simple general IIR filter }
	version { @(#)CG96IIR.pl	1.9 12/8/92 }
	author { Chih-Tsung Huang, ported from Gabriel }
        acknowledge { Gabriel version by Anthony Wong }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 dsp library }
	explanation {
.PP
The star implements an infinite impulse response (IIR) filter.
.PP
The IIR filter can be thought of as a cascade of
an all-pole IIR filter and an all-zero FIR filter,
so \fBdenominator\fR refer to the coefficients for the all-pole filter
and \fBnumerator\fR refer to the coefficients for the all-zero filter.
.PP
To read coefficients from a file, replace the default coefficients
with "<fileName". 
.PP
When designing the coefficients,
it is important to make sure that the denominator polynomial is monic,
i.e. the first coefficient is 1.
Then the \fIdenominator\fR 
contains the coefficients of the inverse-power terms of z.
Therefore, the first number of the taps is c(1).
	}
        seealso { FIR }
	input {
		name {signalIn}
		type {float}
	}
	output {
		name {signalOut}
		type {float}
	}
	state {
		name {numerator}
		type {FLOATARRAY}
		default {"0.25 0.5 0.75 1"}	
		desc { Filter FIR tap values. }
		attributes { A_NONCONSTANT|A_YMEM }
	}
	state {
		name {denominator}
		type {FLOATARRAY}
		default {"0.75 0.5 0.25"}
		desc { Filter IIR tap values. }
		attributes { A_NONCONSTANT|A_YMEM }
	}
	state {
		name {oldsample}
		type {floatarray}
		default {"0"}
        	desc {internal}
               attributes {A_CIRC|A_NONCONSTANT|A_NONSETTABLE|A_XMEM|A_NOINIT}
	}
        state {
                name {oldsampleStart}
	        type {int}
	        default {0}
                desc { pointer to oldsample }
                attributes {A_NONCONSTANT|A_NONSETTABLE|A_XMEM|A_NOINIT}
        }	    
        state {
                name {oldsampleSize}
	        type {int}
	        default {0}
                desc { size of oldsample }
                attributes {A_NONCONSTANT|A_NONSETTABLE}
        }	    
        state {
                name {tapsNumerator}
	        type {int}
	        default {4}
                desc { internal }
                attributes {A_NONCONSTANT|A_NONSETTABLE}
        }	    
        state {
                name {tapsDenominator}
	        type {int}
	        default {4}
                desc { internal }
                attributes {A_NONCONSTANT|A_NONSETTABLE}
        }	    
        state {
                name {minOrder}
	        type {int}
	        default {0}
                desc { internal }
                attributes {A_NONCONSTANT|A_NONSETTABLE}
        }	    
        state {
                name {maxOrder}
	        type {int}
	        default {0}
                desc { internal }
                attributes {A_NONCONSTANT|A_NONSETTABLE}
        }	    

	setup {
              tapsNumerator=numerator.size();
              tapsDenominator=denominator.size();

              int ftn=tapsNumerator;
              int itn=tapsDenominator;

              if (ftn-1>itn)
                    oldsample.resize(int(ftn));
              else if(ftn-1 < itn)
                    oldsample.resize(int(itn));

              denominator.resize(tapsDenominator+1);		    

              StringList temp ="";
              temp += "0";
	      temp += " ";
              for (int d=0; d<tapsDenominator; d++) {
                    temp += denominator[d];
                    temp += " ";
              }

              denominator.setCurrentValue(temp);
        }

        initCode {
                oldsampleSize=oldsample.size();

		if (oldsampleSize>0) 
                     addCode(block);
        }
        
	go {

// The code is divided into 3 cases depending on the order of the filter
//       1. order > 1
//       2. order = 1
//       3. order = 0
//
// Register usage:
// d0.s  cummulative sum of fir product terms / signalOut
// d1.s  cummulative sum of iir product terms
// d2.s  one fir product term
// d3.s  one iir product term
// d4.s  fir coefficient
// d5.s  iir coefficient
// d6.s  oldsample
// d7.s  signalIn / sum of signalIn and all iir product terms

// r0    pointer to fir_const
// r1    pointer to iir_const
// r5    pointer to oldsample
// m5    circular-buffer size of oldsample

                tapsNumerator=tapsNumerator-1;
                int ftaps=tapsNumerator;
                int itaps=tapsDenominator;

		if (ftaps>itaps) {
	            maxOrder=tapsNumerator;
		    minOrder=tapsDenominator;
                }
                else {
	            minOrder=tapsNumerator;
		    maxOrder=tapsDenominator;
		}    
         
                addCode(std);
                if(maxOrder>0) addCode(zero);
		if(maxOrder>1) addCode(one);
                addCode(putInput);
                if(maxOrder>1) {
// balance the two sides
                     addCode(must);
                     if(ftaps > itaps) addCode(greater);
		     else if(ftaps < itaps) addCode(less);

// after the two sides are balanced
                     if(minOrder>0) {
		          if(minOrder>1) addCode(oneB);
			  else addCode(oneZ);
                     }
	             else addCode(minZ);
		}
	        else if(maxOrder==1) {
	             addCode(maxOne);
		     if(ftaps==1) addCode(firOne);
		     if(itaps==1) addCode(iirOne);
		     addCode(doneOne);
		}     
// maxOrder=0;
                else addCode(doneZero);
        }
	codeblock(block) {
; state variable buffer for $fullname()
        org     $ref(oldsample)
        bsc     $val(oldsampleSize),0
        org     p:

; pointer to state variable buffer $fullname()

        org     $ref(oldsampleStart)
        dc      $addr(oldsample)
        org     p:
        }
        codeblock(std) {
; tapsNumerator :$val(tapsNumerator)
; tapsDenominator :$val(tapsDenominator)
        move    #<$val(tapsNumerator)+$addr(numerator),r0
        move    #<$val(tapsDenominator)+$addr(denominator),r1
        }
        codeblock(zero) {
        move    $ref(oldsampleStart),r5
        }
        codeblock(one) {
        move    #<$val(maxOrder)-1,m5
        }
        codeblock(putInput) {    
        move    $ref(signalIn),d7.s
        }
        codeblock(must) {
        fclr    d0
        fclr    d1
        }
        codeblock(greater) {
        fclr    d2      x:(r5)+,d6.s    y:(r0)-,d4.s
        rep     #$val(tapsNumerator)-$val(tapsDenominator)-1
        fmpy    d4,d6,d2        fadd.s  d2,d0   x:(r5)+,d6.s    y:(r0)-,d4.s
        fmpy    d4,d6,d2        fadd.s  d2,d0
        fadd.s  d2,d0
        }
        codeblock(less) {
        fclr    d3      x:(r5)+,d6.s    y:(r1)-,d5.s
        rep     #$val(tapsDenominator)-$val(tapsNumerator)-1
        fmpy    d5,d6,d3        fsub.s  d3,d1   x:(r5)+,d6.s    y:(r1)-,d5.s
        fmpy    d5,d6,d3        fsub.s  d3,d1
        fsub.s  d3,d1
        }
        codeblock(oneB) {
        fclr    d2                      y:(r0)-,d4.s
        fclr    d3      x:(r5)+,d6.s    y:(r1)-,d5.s
        do      #$val(minOrder)-1,$label(loop)
        fmpy    d4,d6,d2        fadd.s  d2,d0                   y:(r0)-,d4.s
        fmpy    d5,d6,d3        fsub.s  d3,d1   x:(r5)+,d6.s    y:(r1)-,d5.s
$label(loop)
        fmpy    d4,d6,d2        fadd.s  d2,d0                   y:(r0)-,d4.s
        fmpy    d5,d6,d3        fsub.s  d3,d1
        fadd.s  d2,d0
        fsub.s  d3,d1
        fadd.s  d1,d7
        fmpy.s  d7,d4,d2        d7.s,x:(r5)+
        fadd.s  d2,d0   r5,$ref(oldsampleStart)
        move    m7,m5
        move    d0.s,$ref(signalOut)
        }
        codeblock(oneZ) {
        fclr    d2                      y:(r0)-,d4.s
        fclr    d3      x:(r5)+,d6.s    y:(r1)-,d5.s
        fmpy    d4,d6,d2        fadd.s  d2,d0                   y:(r0)-,d4.s
        fmpy    d5,d6,d3        fsub.s  d3,d1
        fadd.s  d2,d0
        fsub.s  d3,d1
        fadd.s  d1,d7
        fmpy.s  d7,d4,d2        d7.s,x:(r5)+
        fadd.s  d2,d0   r5,$ref(oldsampleStart)
        move    m7,m5
        move    d0.s,$ref(signalOut)
        }
        codeblock(minZ) {
        move    y:(r0),d4.s
        fadd.s  d1,d7
        fmpy.s  d7,d4,d2        d7.s,x:(r5)+
        fadd.s  d2,d0   r5,$ref(oldsampleStart)
        move    m7,m5
        move    d0.s,$ref(signalOut)
        }
        codeblock(maxOne) {
        fclr    d0.s    x:(r5),d6.s     y:(r0),d4.s
        fclr    d1.s                    y:(r1),d5.s
        }
        codeblock(firOne) {
        fmpy.s  d4,d6,d0        y:-(r0),d4.s
        }
        codeblock(iirOne) {
        fmpy.s  d5,d6,d1
        }
        codeblock(doneOne) {
        fsub.s  d1,d7
        fmpy.s  d7,d4,d2        d7.s,x:(r5)
        fadd.s  d2,d0
        move    d0.s,$ref(signalOut)
        }
        codeblock(doneZero) {
        move    y:(r0),d4.s
        fmpy.s  d7,d4,d0
        move    d0.s,$ref(signalOut)
        }

	execTime {
               if(maxOrder>1) {
	            if(tapsNumerator==0 || tapsDenominator==0)
		        return  17 + tapsNumerator + tapsDenominator;
		    else if(tapsNumerator==1 || tapsDenominator==1)
		        return  20 + tapsNumerator + tapsDenominator;
		    else if(tapsNumerator==tapsDenominator)
		        return  19 + tapsNumerator + tapsDenominator;
                    else
		        return  22 + tapsNumerator + tapsDenominator;
                }
	        else if(maxOrder==1)
		        return  10 + tapsNumerator + tapsDenominator;
                else return 6;
        }
}
