defstar {
	name { FIR }
	domain { CG96 }
	desc { A Finite Impulse Response (FIR) filter. }
	version { @(#)CG96FIR.pl	1.12 12/8/92 }
	author { Chih-Tsung Huang, ported from Gabriel }
        acknowledge { Gabriel version by Anthony Wong }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 dsp library }
	explanation {
.PP
The star implements a finite impulse response filter
with multirate capability.
.PP
Coefficients are in the "taps" state variable.
Default coefficients give an 8th order, linear phase lowpass filter.
To read coefficients from a file, replace the default coefficients
with "<fileName".
.PP
The parameters \fIdecimation\fR and \fIinterpolation\fR enable this star
to perform downsampling or upsampling.
Only one of these 2 parameters can be set to greater than 1.
.PP
For decimation, the sample that is taken is controlled
by the parameter \fIdecimationPhase\fR.
If \fIdecimationPhase\fR = 0, the most recent sample is the signalOut;
while if \fIdecimationPhase\fR = \fIdecimation\fR-1,
the oldest sample is the signalOut.
	}
        seealso { IIR }
	input {
		name {signalIn}
		type {float}
	}
	output {
		name {signalOut}
		type {float}
	}
	state {
		name {taps}
		type {FLOATARRAY}
		default {
	"-.040609 -.001628 .17853 .37665 .37665 .17853 -.001628 -.040609"
		}
		desc { Filter tap values. }
		attributes { A_NONCONSTANT|A_YMEM }
		
	}
	state {
		name {decimation}
		type {int}
		default {1}
		desc {Decimation ratio.}
	}
	state {
		name {decimationPhase}
		type {int}
		default {0}
		desc {Decimation phase.}
	}
	state {
		name {interpolation}
		type {int}
		default {1}
		desc {Interpolation ratio.}
	}
	state {
		name {oldsample}
		type {floatarray}
		default {0}
		desc {internal}
                attributes {
               A_CIRC|A_NONCONSTANT|A_NONSETTABLE|A_XMEM|A_NOINIT
	        }
	}
        state {
                name {oldsampleStart}
	        type {int}
	        default {0}
                desc { pointer to oldsample }
                attributes {A_NONCONSTANT|A_NONSETTABLE|A_XMEM|A_NOINIT}
        }	    
        state {
                name {oldsampleSize}
	        type {int}
	        default {0}
                desc { size of oldsample }
                attributes {A_NONCONSTANT|A_NONSETTABLE}
        }	    
        state {
                name {tapsNum}
	        type {int}
	        default {8}
                desc { internal }
                attributes {A_NONCONSTANT|A_NONSETTABLE}
        }	    
        state {
                name {eftaps}
	        type {int}
	        default {0}
                desc { internal }
                attributes {A_NONCONSTANT|A_NONSETTABLE}
        }	    
        state {
                name {index}
	        type {int}
	        default {0}
                desc { internal }
                attributes {A_NONCONSTANT|A_NONSETTABLE}
        }	    
        state {
                name {adjust}
	        type {int}
	        default {0}
                desc { internal }
                attributes {A_NONCONSTANT|A_NONSETTABLE}
        }	    
        state {
                name {flag}
                type {int}
                default {0}
                desc { internal }
                attributes {A_NONCONSTANT|A_NONSETTABLE}
        }
	setup {
              tapsNum=taps.size();
              oldsample.resize(int((int(tapsNum)-1)/int(interpolation)));
              int modtemp=tapsNum%interpolation;

              signalIn.setSDFParams(decimation, decimation-1);
	      signalOut.setSDFParams(interpolation, interpolation-1);

              if (decimation>1 && interpolation>1) 
	              Error::abortRun (*this, ": Cannot both interpolate and decimate.");
              if (decimationPhase>=decimation)
	              Error::abortRun (*this, ": Decimation phase invalid");
                
          
	      if (flag == 0) {
              	if (modtemp !=0) {
	             taps.resize(tapsNum+interpolation-modtemp);
		     tapsNum=taps.size();
	      	}
//  Permute the coefficients if interpolation > 1

              	StringList permuted ="";
              	for (int i=interpolation-1; i> -1; i--) {
                    int j=i;
                    while(j<tapsNum) {
		            permuted +=taps[j];
			    permuted +=" ";
                            j +=interpolation;
		    }
              	}
	      	taps.setCurrentValue(permuted);
		flag = 1;
	     }
        }

        initCode {
                oldsampleSize=oldsample.size();

		if (oldsampleSize>0) 
                     addCode(block);
        }
        
	go {

// 2 cases, each with 3 subcases
//
// 1. (interpolation = 1)
//       a. taps > 2
//       b. taps = 2
//       c. taps = 1
// 2. (interpolation > 1)
//       a. taps > 2
//       b. taps = 2
//       c. taps = 1
//
// Register usage
//
// d0.s  total sum
// d2.s  one product term
// d4.s  one oldsample / oldsample-signalIn for decimation case
// d6.s  one tap value
// d8.s  signalIn
//
// r0    pointer to tap value
// r2    pointer to last oldsample (used only when interpolation > 1)
// r4    pointer to oldsample
// r6    pointer to signalIn for decimation / pointer to signalOut for interpolation
//
// m4    circular buffer size for oldsample


                eftaps= int(tapsNum/interpolation);
                index = decimation-decimationPhase-1;
         
// Normal case - interpolation =1
         
                if(interpolation==1) {
	             if(tapsNum>1) addCode(first);
		     if(tapsNum>2) {
		         addCode(gTwo);
			 if(index>0) addCode(loop);
                         addCode(gTwoCont);
                         if(decimationPhase>0) addCode(dloop);
                         addCode(doneTwo);
		     }
		     else if(tapsNum==2) {
		         if(index>0) {
		            adjust=index-1;
			    addCode(iZero);
			 }   
		         else if(decimation>1) {
		            adjust=decimation-1;
		            addCode(dOne);
                         } 
			 else addCode(two);
		     }	 
                     else          // tapsNum=1
                         addCode(one);
		}	 
// Interpolation -- interpolation > 1        
                else {

// cases for different types of taps
                     if(eftaps>2)  addCode(twoG);

		     else if(eftaps==2) {
		          addCode(equal);
			  if(interpolation>2)
		                 addCode(eqloop);
		          else
		                 addCode(noeqloop);
		     }
		     else {
		          if(interpolation>2)
		                 addCode(oneLoop);
		          else
		                 addCode(oneNoLoop);
		     }		 
	        }            
        }
	codeblock(block) {
; state variable buffer for $fullname()
        org     $ref(oldsample)
        bsc     $val(oldsampleSize),0
        org     p:

; pointer to state variable buffer $fullname()

        org     $ref(oldsampleStart)
        dc      $addr(oldsample)
        org     p:
        }

        codeblock(first) {
        move    #<$val(tapsNum)+$addr(taps)-1,r0
        }

        codeblock(gTwo) {
        move    #<$addr(signalIn),r6
        move    $ref(oldsampleStart),r4
        move    #<$val(tapsNum)-2,m4
        }    
        codeblock(loop) {
        do      #$val(index),$label(lab1)
        move    x:(r6)+,d8.s
        move    d8.s,x:(r4)+
$label(lab1)
        }    
        codeblock(gTwoCont) {
        move    x:(r6)+,d8.s
        fclr    d2
        fclr    d0      x:(r4)+,d4.s    y:(r0)-,d6.s
        rep     #$val(tapsNum)-2
        fmpy    d4,d6,d2        fadd.s d2,d0    x:(r4)+,d4.s    y:(r0)-,d6.s
        fmpy    d4,d6,d2        fadd.s d2,d0    y:(r0)-,d6.s
        fmpy    d8,d6,d2        fadd.s d2,d0    d8.s,x:(r4)+
        fadd.s  d2,d0
        }           
        codeblock(dloop) {
        do      #$val(decimationPhase),$label(lab2)
        move    x:(r6)+,d8.s
        move    d8.s,x:(r4)+
$label(lab2)
        }
        codeblock(doneTwo) {
        move    r4,$ref(oldsampleStart)
        move    m7,m4
        move    d0.s,$ref(signalOut)
        }    
        codeblock(iZero) {
        move    $ref2(signalIn,index),d8.s
        move    $ref2(signalIn,adjust),d4.s
        move    y:(r0)-,d6.s
        fmpy.s  d4,d6,d2        y:(r0)-,d6.s
        fmpy.s  d8,d6,d0
        fadd.s  d2,d0
        move    d0.s,$ref(signalOut)
        }
        codeblock(dOne) {
        move    $ref2(signalIn,index),d8.s
        move    $ref(oldsample),d4.s
        move    $ref2(signalIn,adjust),d0.s
        move    d0.s,$ref(oldsample)
        move    y:(r0)-,d6.s
        fmpy.s  d4,d6,d2        y:(r0)-,d6.s
        fmpy.s  d8,d6,d0
        fadd.s  d2,d0
        move    d0.s,$ref(signalOut)
        }
        codeblock(two) {
        move    $ref2(signalIn,index),d8.s
        move    $ref(oldsample),d4.s
        move    d8.s,$ref(oldsample)
        move    y:(r0)-,d6.s
        fmpy.s  d4,d6,d2        y:(r0)-,d6.s
        fmpy.s  d8,d6,d0
        fadd.s  d2,d0
        move    d0.s,$ref(signalOut)
        }
        codeblock(one) {
        move    $ref2(signalIn,index),d8.s
        move    $ref(taps),d6.s
        fmpy.s  d8,d6,d0
        move    d0.s,$ref(signalOut)
        }    
      
        codeblock(twoG) {
        move    #>$val(eftaps)*$val(interpolation)+$addr(taps)-1,r0
        move    $ref(signalIn),d8.s
        move    #<$addr(signalOut),r6    
        move    $ref(oldsampleStart),r4
        move    #<$val(eftaps)-2,m4
        fclr    d2
        fclr    d0      x:(r4)+,d4.s    y:(r0)-,d6.s
        do      #$val(interpolation)-1,$label(lab1)
        rep     #$val(eftaps)-1
        fmpy    d4,d6,d2        fadd.s  d2,d0   x:(r4)+,d4.s    y:(r0)-,d6.s
        fmpy    d8,d6,d2        fadd.s  d2,d0   y:(r0)-,d6.s
        fadd.s  d2,d0
        fclr    d0      d0.s,x:(r6)+
        fclr    d2
$label(lab1)
        rep     #$val(eftaps)-2
        fmpy    d4,d6,d2        fadd.s  d2,d0   x:(r4)+,d4.s    y:(r0)-,d6.s
        fmpy    d4,d6,d2        fadd.s  d2,d0   y:(r0)-,d6.s
        fmpy    d8,d6,d2        fadd.s  d2,d0   d8.s,x:(r4)+
        fadd.s  d2,d0   r4,$ref(oldsampleStart)
        move    m7,m4
        move    d0.s,x:(r6)+
        }

        codeblock(equal) {
        move    #>$val(eftaps)*$val(interpolation)+$addr(taps)-1,r0
        move    $ref(signalIn),d8.s
        move    #<$addr(signalOut),r6
        move    $ref(oldsampleStart),r4
        fclr    d0
        move            x:(r4),d4.s     y:(r0)-,d6.s
        fmpy.s  d4,d6,d2        y:(r0)-,d6.s
        fmpy    d8,d6,d2        fadd.s  d2,d0   y:(r0)-,d6.s
        fadd.s  d2,d0
        }
        codeblock(eqloop) {
        do      #$val(interpolation)-2,$label(lab1)
        fmpy.s  d4,d6,d2        d0.s,x:(r6)+    y:(r0)-,d6.s
        fclr    d0
        fmpy    d8,d6,d2        fadd.s d2,d0    y:(r0)-,d6.s
        fadd.s  d2,d0
$label(lab1)
        fmpy.s  d4,d6,d2        d0.s,x:(r6)+    y:(r0)-,d6.s
        fclr    d0
        fmpy    d8,d6,d2        fadd.s  d2,d0   d8.s,x:(r4)
        fadd.s  d2,d0
        move    d0.s,x:(r6)+
        }
        codeblock(noeqloop) {
        fmpy.s  d4,d6,d2        d0.s,x:(r6)+    y:(r0)-,d6.s
        fclr    d0
        fmpy    d8,d6,d2        fadd.s  d2,d0   d8.s,x:(r4)
        fadd.s  d2,d0
        move    d0.s,x:(r6)+
        }    
        codeblock(oneLoop) {
        move    #>$val(eftaps)*$val(interpolation)+$addr(taps)-1,r0
        move    $ref(signalIn),d8.s
        move    #<$addr(signalOut),r6
        move    y:(r0)-,d6.s
        fmpy.s  d8,d6,d0        y:(r0)-,d6.s
        rep     #$val(interpolation)-2
        fmpy.s  d8,d6,d0        d0.s,x:(r6)+    y:(r0)-,d6.s
        fmpy.s  d8,d6,d0        d0.s,x:(r6)+
        move    d0.s,x:(r6)+
        }

        codeblock(oneNoLoop) {
        move    #>$val(eftaps)*$val(interpolation)+$addr(taps)-1,r0
        move    $ref(signalIn),d8.s
        move    #<$addr(signalOut),r6
        move    y:(r0)-,d6.s
        fmpy.s  d8,d6,d0        y:(r0)-,d6.s
        fmpy.s  d8,d6,d0        d0.s,x:(r6)+
        move    d0.s,x:(r6)+
        }


	execTime {
               return 20;
        }
}
