defstar {
	name {Burg}
	domain {CG96}
	desc { Burg's algorithm for estimation of reflection ceofficients }
	version {@(#)CG96Burg.pl	1.7 12/8/92}
	author { Chih-Tsung Huang, ported from gabriel }
        acknowledge { Gabriel version by Anthony Wong }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 dsp library }
        explanation {
.PP
This star uses Burg's algorithm to estimate
the reflection coefficients of an input random process.
The number of inputs looked at is given by
the \fInumInputs\fR parameter and the order of the AR model
is given by the \fIorder\fR parameter.
The order specifies how many outputs appear on the output.
.PP
Note that the definition of reflection coefficients
is not quite universal in the literature.
The reflection coefficients generated by this star
are the negative of the ones corresponding to
the definition of partial-correlation (PARCOR)
coefficients in the statistics literature.
.UH REFERENCES
.IP [1]
S. M. Kay, \fIModern Spectral Estimation: Theory & Application\fR,
Prentice-Hall, Englewood Cliffs, NJ, 1988.
.IP [2]
S. Haykin, \fIModern Filters\fR, MacMillan Publishing Company,
New York, 1989.
	}
	input {
		name{input}
		type{float}
	}
	output {
		name{output}
		type{float}
	}
        state {
                name {numInputs}
                type {int}
                default {64}
                desc { The number of inputs used to estimate the model.}
        }
	state {
		name {order}
		type {int}
		default {16}
                desc {The number of reflection coefficients to generate.}
	}
	state {
		name {fp}
		type {floatarray}
		default {"0"}
		desc {internal}
	        attributes {A_XMEM|A_NONCONSTANT|A_NONSETTABLE|A_NOINIT}
        }
	state {
		name {bp}
		type {floatarray}
		default {"0"}
		desc {internal}
	        attributes {A_YMEM|A_NONCONSTANT|A_NONSETTABLE|A_NOINIT}
        }
	setup {
		if (int(order) >= int(numInputs)) {
			Error::abortRun(*this,
			   ": Number of lags >= number of samples.");
			return;
		}
		input.setSDFParams(int(numInputs),int(numInputs)-1);
		output.setSDFParams(int(order),int(order)-1);
                fp.resize(int(numInputs));
                bp.resize(int(numInputs));
	}
        initCode {
                addCode(block);
	}	
        codeblock(block) {
; initialize the fp in $fullname()
        org     $ref(fp)
        bsc     $val(numInputs),0.0
        org     p:
; initialize the bp in $fullname()
        org     $ref(bp)
        bsc     $val(numInputs),0.0
        org     p:
        }

        codeblock(main) {
; move input and calculate k1
        move    #>$addr(input),r0
        move    #<$addr(fp),r2
        move    #>$addr(bp),r4
        move    #>$addr(output),r6
        fclr    d0.s    x:(r0)+,d6.s
        fclr    d1.s    x:(r0)+,d4.s
        fclr    d2.s    d6.s,d7.s
        fmpy.s  d6,d7,d3        d6.s,x:(r2)+    d7.s,y:(r4)+
        do      #$val(numInputs)-2,$label(inloop)
        fmpy    d4,d6,d2        fsub.s  d2,d0   d4.s,d5.s
        fmpy    d4,d5,d3        fadd.s  d3,d1   d5.s,d6.s
        fadd.s  d3,d1   x:(r0)+,d4.s
        move    d5.s,x:(r2)+    d6.s,y:(r4)+
$label(inloop)
        fmpy    d4,d6,d2        fsub.s  d2,d0   d4.s,d5.s
        fmpy    d4,d5,d3        fadd.s  d3,d1
        fsub.s  d2,d0   d4.s,x:(r2)+    d5.s,y:(r4)+
        fadd.s  d3,d1
        fadd.s  d0,d0
        fseedd  d1,d6
        fmpy.s  d1,d6,d1        #2.0,d4.s
        fsub.s  d1,d4           d4.s,d3.s
        fmpy.s  d1,d4,d1
        fmpy    d6,d4,d1        fsub.s d1,d3
        fmpy.s  d1,d3,d1
        fmpy.s  d0,d1,d7
        move    d7.s,x:(r6)+
        }

        codeblock(one) {
; calculate other reflection coefficients
        move    #>$val(numInputs)-2,d5.l
        do      #$val(order)-1,$starSymbol(grandloop)
; update forward and backward prediction errors
        move    #>$addr(fp)+1,r2
        move    #<$addr(fp),r3
        move    #>$addr(bp),r4
        move    r4,r5
        move    d7.s,d8.s
        move    x:(r2)+,d4.s    y:(r4)+,d6.s
        fmpy.s  d6,d8,d2        d5.l,d9.l
        fmpy    d4,d8,d3        fadd.s  d4,d2
        fadd.s  d6,d3   x:(r2)+,d4.s    y:(r4)+,d6.s
        do      d9.l,$label(udloop)
        fmpy.s  d6,d8,d2        d2.s,x:(r3)+    d3.s,y:(r5)+
        fmpy    d4,d8,d3        fadd.s  d4,d2
        fadd.s  d6,d3   x:(r2)+,d4.s    y:(r4)+,d6.s
$label(udloop)
        move    d2.s,x:(r3)+    d3.s,y:(r5)+
; compute next reflection coefficient
        move    #>$addr(fp)+1,r2
        move    #>$addr(bp),r4
        fclr    d0.s    x:(r2)+,d4.s
        fclr    d1.s    y:(r4)+,d6.s
        fclr    d3.s
        do      d9.l,$label(rcloop)
        fmpy    d4,d6,d2        fadd.s  d3,d1   d4.s,d5.s
        fmpy    d4,d5,d3        fsub.s  d2,d0   d6.s,d7.s
        fmpy    d6,d7,d3        fadd.s  d3,d1   x:(r2)+,d4.s    y:(r4)+,d6.s
$label(rcloop)
        fadd.s  d3,d1
        fadd.s  d0,d0
        fseedd  d1,d6
        fmpy.s  d1,d6,d1        #2.0,d4.s
        fsub.s  d1,d4           d4.s,d3.s
        fmpy.s  d1,d4,d1
        fmpy    d6,d4,d1        fsub.s d1,d3
        fmpy.s  d1,d3,d1
        fmpy.s  d1,d0,d7        d9.l,d5.l
        move    d7.s,x:(r6)+
        dec     d5.l
$starSymbol(grandloop)
        }    
        
 	go {

// move input and calculate k1
// d0.s      (half of) total sum in numerator
// d1.s      total sum of denominator
// d2.s      one product term for the numerator
// d3.s      one product term for the denominator
// d4.s      input sample
// d5.s        "     "
// d6.s      previous input sample
// d8.s      reflection coefficient

// r0        points to input
// r2        points to forward prediction error
// r4        points to backward prediction error
// r6        points to output


             addCode(main);
	     if(int(order)> 1) addCode(one);
	}
        execTime {
             if(int(order)==1) return 19+ (4*int(numInputs));
	     else
               return  (19+ (4*int(numInputs))+
	               (int(order)-1)*(35+(3*(int(order)-1)*int(order))));
         
        }
}

