defstar {
	name { BlockLattice }
	domain { CG96 }
	desc { Block FIR Lattice Filter }
	version { @(#)CG96BlockLattice.pl	1.8 12/8/92 }
	author { Chih-Tsung Huang }
        acknowledge { Gabriel version by Anthony Wong }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 dsp library }
	explanation {
This star implements an FIR lattice filter with coefficients
that are periodically updated from the outside.
The \fIblockSize\fR parameter tells how often the updates occur.
It is an interger specifying how many input samples
should be processed using each set of coefficients.
The \fIorder\fR parameter tells how many coefficients there are.
	}
        seealso { FIRLattice }
	input {
		name {input}
		type {float}
	}
	input {
		name {taps}
		type {float}
	}
        output {
		name {fp}
		type {float}
	}
	output {
		name {bp}
		type {float}
	}
	state {
		name {constant}
		type {floatarray}
		default {"0"}
		desc {internal}
                attributes { A_NONCONSTANT|A_NONSETTABLE|A_YMEM|A_NOINIT }
	}
	state {
		name {oldsample}
		type {floatarray}
		default {"0"}
		desc {internal}
                attributes { A_NONCONSTANT|A_NONSETTABLE|A_XMEM|A_NOINIT }
	}
        state {
                name {blockSize}
	        type {int}
	        default {128}
                desc { Number of inputs that use each each coefficient set. }
        }
        state {
                name {order}
	        type {int}
	        default {16}
                desc { Number of new coefficients to read each time. }
        }


	codeblock(block) {
; coefficients for $fullname()
        org     $ref(constant)
        bsc     $val(order),0
        org     p:

; state variable buffer for $fullname()
        org     $ref(oldsample)
        bsc     $val(order),0
        org     p:
        }

        codeblock(one) {
        move    #<$addr(input),r0
        move    #<$addr(fp),r6
        move    #>$addr(bp),r7
        move    $ref(taps),d4.s
        do      #$val(blockSize),$label(blkLoop)
        move    x:(r0)+,d0.s
        move    $ref(oldsample),d1.s
        move    d0.s,$ref(oldsample)
        fmpy.s  d0,d4,d3
        fmpy.s  d1,d4,d2
        fadd.s  d3,d1
        fadd.s  d2,d0
        move    d0.s,x:(r6)+
        move    d1.s,x:(r7)+
$label(blkLoop)
        }

        codeblock(greater) {
        move    #<$addr(input),r0
        move    #<$addr(fp),r6
        move    #>$addr(bp),r7
        move    #<$addr(constant),r2
        move    #>$addr(taps),r4
        do      #$val(order),$label(coefLoop)
        move    x:(r4)+,d0.s
        move    d0.s,y:(r2)+
$label(coefLoop)
        do      #$val(blockSize),$label(blkLoop)
        move    #>$addr(oldsample),r4
        move    #<$addr(constant),r2
        move    x:(r0)+,d0.s
        ftfr.s  d0,d1   x:(r4),d5.s     y:(r2)+,d4.s
        do      #$val(order),$label(loop)
        fmpy.s  d0,d4,d1        d1.s,x:(r4)+
        fmpy    d5,d4,d2        fadd.s  d5,d1
        fadd.s  d2,d0   x:(r4),d5.s     y:(r2)+,d4.s
$label(loop)
        move    d0.s,x:(r6)+
        move    d1.s,x:(r7)+
$label(blkLoop)
        }
	setup {
              constant.resize(order);
              oldsample.resize(order);
              input.setSDFParams(blockSize, blockSize-1);
              taps.setSDFParams(order,order-1);        
              fp.setSDFParams(blockSize, blockSize-1);
              bp.setSDFParams(blockSize, blockSize-1);
        }


        initCode {
               addCode(block);
        }
        
	go {
               if(order==1)
	               addCode(one);
	       else
	               addCode(greater);
        }


	execTime {

               if(order>1)
	            return 9+(2*int(order))+(int(blockSize)*(8+3*int(order)));
	       else
	            return 9*int(blockSize) + 6;
        }
}
