defstar {
	name { VarTime }
	domain { CG }
	desc { An abstract baseclass }
	version { @(#)CGVarTime.pl	1.7 12/10/92 }
	author { J. T. Buck }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG demo library }
	explanation {
An abstract baseclass for stars whose execution times can be set, for use in
scheduling experiments.  You cannot create a CGVartime star, only inherit
from it.
	}
	defstate {
		name { runTime }
		type { int }
		default { 1 }
		desc { runtime for this star }
	}
	// make this a pure virtual base class
	constructor {
		noInternalState();
	}
	pure method { name { go }}
	// redefine run to add star full name
	method {
		name { run }
		type { int }
		arglist { "()" }
		code {
			StringList msg = "/* code generated by ";
			msg << fullName() << " */\n";
			addCode(msg);
			return CGStar::run();
		}
	}
	execTime {
		return int(runTime);
	}
}
