static const char file_id[] = "CGDisplay.cc";
/******************************************************************
Version identification:
@(#)CGDisplay.cc	1.7	12/10/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer: J. Pino

 Display routines. 
 
*******************************************************************/
#include <stdio.h>
#include "StringList.h"
#include "CGDisplay.h"
#include "pt_fstream.h"
#include "Error.h"
#include "miscFuncs.h"

static const char defaultDisplay[] = "xedit -name ptolemy_code %s";

// "display" stuff into filename.  If filename is null, make a tempfile.
int display(const StringList& stuff, const char* filename) {
	int status = FALSE;
	const char* dispCmd = getenv ("PT_DISPLAY");
	if (dispCmd == 0) dispCmd = defaultDisplay;
	char* tmpFile = 0;
	if (filename == NULL) {
		tmpFile = tempFileName();
		filename = tmpFile;
	}
	pt_ofstream o(filename);
	if (o) {
		o << stuff;
		o.flush();
		StringList command;
		// surround command with "()" if tmpFile set
		if (tmpFile)
			command << "(";
		char cmdbuf[256];
		sprintf (cmdbuf, dispCmd, filename);
		command << cmdbuf;
		if (tmpFile)
			command << " ; rm " << filename << ")";
		command << " &";
		system(command);
		status = TRUE;
	}
	if (tmpFile) {
		LOG_DEL; delete [] tmpFile;
	}
	return status;
}
