#ifndef _CGRecurScheduler_h
#define _CGRecurScheduler_h 1
#ifdef __GNUG__
#pragma interface
#endif

#include "CGConScheduler.h"
#include "CGDDFWormhole.h"
#include "Recur.h"
#include "Profile.h"

/**************************************************************************
Version identification:
@(#)CGRecurScheduler.h	1.2	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Soonhoi Ha

 Scheduler for "Recur" construct.

**************************************************************************/

class CGRecurScheduler : public CGConScheduler, public Recur {

public:
	// read the statistics on the number of iteration steps.
	int getStatistics(Target*);

	// download the code
	void downLoadCode(int, Target*, Profile*);

	// constructor
	CGRecurScheduler();
	~CGRecurScheduler();

protected:
	// redefine the virtual methods.
	int examine(Galaxy& galaxy);
	int closerExamine();
	// redefine
	int setProfile(int, int, Profile*);

	// return the assumed execution time
	int assumeExecTime();

	// add control and synchronization codes to the profile.
	// returns the cost of these codes.
	int addControlCodes(int, Profile*);

	// virtual methods to be filled for a specific target.
	virtual int myControlTime();
	virtual int mySyncTime();
	
	virtual const char* controlCode(int);
	virtual const char* commonControlCode();
	virtual const char* syncCode(int);
	virtual const char* commonSyncCode();
	

private:
	// number of "Self" stars -> width of recursion.
	int numSelf;

	double calcCost(int, int);	  // compute the optimal total cost.
	double costInGeometric(int, int); // in Geometric dist.
	double costInUniform(int, int);   // in Uniform dist.
	double costInGeneral(int, int);   // in General dist.
	int adjustX(int,int,int,int);	  // adjust "x" value.

	// wormholes and profiles
	Profile** body;		 // profile of the recursion body.
	CGDDFWormhole* wormA;
	CGDDFWormhole* wormB;
	CGDDFWormhole* wormC;
	CGDDFWormhole* wormD;
	
	// length of one path
	int pathLeng;
};

#endif
