static const char file_id[] = "CGDDFWormhole.cc";

/******************************************************************
Version identification:
 @(#)CGDDFWormhole.cc	1.7	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer: Soonhoi Ha 
 Date of creation: 6/15/90
 Date of revision: 6/20/90

*******************************************************************/

#ifdef __GNUG__
#pragma implementation
#endif

#include "CGDDFWormhole.h"
#include "CGStar.h"
#include "StringList.h"
#include "Error.h"
#include "GalIter.h"
#include "Scheduler.h"

/*******************************************************************

	class CGDDFWormhole methods

********************************************************************/

extern const char CGdomainName[];

void CGDDFWormhole :: setup() {
	// check whether the inner domain is CG. If not, currently error.
	if (strcmp(target->starType(), "CGStar")) {
		Error::abortRun("CGDDFWormhole is not defined with ", 
			target->starType(), " stars inside.");
		return;
	}
	
	// get the number fo processors.
	assignProcs(targetPtr->nProcs());

	if (mtarget) {
		// inform the how many processors are available
		mtarget->setTargets(numProcs);
                mtarget->initState();

                // Inherit the outside child targets to inside if necessary.
                if (mtarget->inherited()) {
			if (!mtarget->inheritChildTargets(targetPtr)) return;
		}
	}

	// setup
	Wormhole :: setup();

	if (mtarget) {
		mtarget->setProfile(&profile[numProcs-1]);

		// schedule it with less processors.
		for (int i = numProcs - 1; i > 0; i--) {
			if (!mtarget->computeProfile(i,0,0)) break;
			mtarget->setProfile(&profile[i-1]);
		}
	}
}

void CGDDFWormhole :: go() {
	// set the currentTime of the inner domain.
	target->setCurrentTime(outerSched()->now());

	// run
	Wormhole::run();
}

CGDDFWormhole* CGDDFWormhole :: myWormhole() {
	return this;
}

/**********************************************
  Make the inside galaxy ready for scheduling.
 **********************************************/

// Constructor
CGDDFWormhole :: CGDDFWormhole(Galaxy& g, Target* t) : 
	Wormhole(*this,g,t), mtarget(0), prevNum(0)
{
	buildEventHorizons ();
	profile = (Profile *) 0;
	numProcs = 0;
}

CGDDFWormhole :: ~CGDDFWormhole() {
	DEL_ARRAY(profile,prevNum);
	freeContents();
}

// cloner -- clone the inside and make a new wormhole from that.
Block* CGDDFWormhole :: clone() const {
	LOG_NEW; return new CGDDFWormhole(gal.clone()->asGalaxy(), 
		target->cloneTarget());
}

// download the code
void CGDDFWormhole :: downLoadCode(int index) {
	if (!mtarget) return;
        if (mtarget->inherited())
            mtarget->setCurChild(((MultiTarget*)targetPtr)->getCurChild());
        mtarget->downLoadCode(index % numProcs, 0);
}

/******************************************************************
		Methods for parallel scheduler
 *****************************************************************/

void CGDDFWormhole :: assignProcs(int num) {
	// set-up the processors
	if (num <= 0) {
		StringList out;
		out += "illegal number of processors are requested.";
		Error::abortRun(*this, out);
	} else if (numProcs == num) {
                for (int i = 0; i < numProcs; i++)
                        profile[i].initialize();
        } else {
		DEL_ARRAY(profile,prevNum);
		prevNum = numProcs = num;
		LOG_NEW; profile = new Profile[numProcs];
                for (int i = 0; i < numProcs; i++) {
                        profile[i].create(i+1);
                }
	}

	// Currently, CGDDFTarget is defined under quasi-CG target.
	mtarget = (MultiTarget*) target;
}

