/******************************************************************
Version identification:
@(#)CGDDFTarget.h	1.9	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer: Soonhoi Ha

 Baseclass for all quasi-static code generation targets.
 This target is the base target of dynamic-construct target such as
 CaseTarget, ForTarget, etc. The appropriate scheduler will be determined
 in the derived Target.
 This target contains all common functionalities.

*******************************************************************/

#ifndef _CGDDFTarget_h
#define  _CGDDFTarget_h 1

#ifdef __GNUG__
#pragma interface
#endif

#include "MultiTarget.h"
#include "Profile.h"
#include "StringState.h"
#include "IntState.h"
#include "FloatState.h"

class CGConScheduler;

class CGDDFTarget : public MultiTarget {
public:
	CGDDFTarget(const char* name, const char* starclass, const char* desc);
	Block* makeNew() const;
	void setup();

	// complete the profile
	void setProfile(Profile* p);

	// compute the profile of this galaxy
	int computeProfile(int nP,int resWork, IntArray* avail);

	// compute the inside schedule
	void insideSchedule();

	// inherit child targets
	int inheritChildTargets(Target*);

	// downLoadCode
	void downLoadCode(int, Profile*);

	// average execution time
	int totalWorkLoad();

	// display schedules of wormholes.
	StringList displaySchedule();

	// redefine pure virtual methods
	DataFlowStar* createReceive(int,int,int);
	DataFlowStar* createSend(int,int,int);
	DataFlowStar* createSpread();
	DataFlowStar* createCollect();

protected:
	CGConScheduler* conSched;
	Profile* profile;

	// construct type
        StringState constructType;		// distribution type

	// distribution parameters
        StringState paramType;			// distribution type
        FloatState  paramGeo;			// geometric constant
        IntState    paramMin;			// min. value of the parameter
        IntState    paramMax;			// max. value of the parameter
        StringState paramFile;			// file name for distribution.

	// fix the number of assigned processors.
	IntState    fixedNum;
};
#endif
