static const char file_id[] = "CGDDFTarget.cc";

/******************************************************************
Version identification:
@(#)CGDDFTarget.cc	1.12	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer: Soonhoi ha

 Baseclass for all quasi-static code generation targets.

*******************************************************************/

#ifdef __GNUG__
#pragma implementation
#endif

#include "CGDDFTarget.h"
#include "Error.h"
#include "KnownTarget.h"
#include "CGDDFWormhole.h"
#include "GalIter.h"
#include "CGUtilities.h"
#include "CGCaseScheduler.h"
#include "CGForScheduler.h"
#include "CGDoWhileScheduler.h"
#include "CGRecurScheduler.h"

// constructor
CGDDFTarget::CGDDFTarget(const char* name,const char* starclass,
	const char* desc) : MultiTarget(name,starclass,desc), 
	profile(0), conSched(0) 
{
        addState(fixedNum.setState("fixedNum",this,"0",
                                    "fix the number of assigned procs?"));
        addState(constructType.setState("constructType",this,"case",
                                    "type of dynamic construct"));
        addState(paramType.setState("paramType",this,"geometric",
                                    "distribution type of parameter"));
        addState(paramGeo.setState("paramGeo",this,"0.5",
                                    "parameter for geometric dist."));
        addState(paramMin.setState("paramMin",this,"0",
              "minimum value of the parameter for geo. or uni. distribution"));
        addState(paramMax.setState("paramMax",this,"1",
              "maximum value of the parameter of uniform distribution"));
        addState(paramFile.setState("paramFile",this,"defParams",
              "file name which store a general distribution of parameter"));
	inheritProcessors.setInitValue("YES");

	// make some states are invisible in this domain
	nprocs.setAttributes(A_NONSETTABLE);
	sendTime.setAttributes(A_NONSETTABLE);

	// no choice of scheduler
	oneStarOneProc.setAttributes(A_NONSETTABLE);
	manualAssignment.setAttributes(A_NONSETTABLE);
	adjustSchedule.setAttributes(A_NONSETTABLE);
}

Block* CGDDFTarget :: makeNew() const {
	LOG_NEW; return new CGDDFTarget(name(),starType(),descriptor());
}

void CGDDFTarget :: setProfile(Profile* p) { profile = p; }

void CGDDFTarget :: setup() {
	// scheduler setup
	delSched();
	char* cType = makeLower((const char*) constructType);
	switch (*cType) {
		case 'c': LOG_NEW; setSched(new CGCaseScheduler);
			break;
		case 'd': LOG_NEW; setSched(new CGDoWhileScheduler);
			break;
		case 'f': LOG_NEW; setSched(new CGForScheduler);
			break;
		case 'r': LOG_NEW; setSched(new CGRecurScheduler);
			break;
		default:
			Error::abortRun(*this, "unknown construct type");
			return;
	} 

	// read the distribution information
	conSched = (CGConScheduler*) scheduler();
	if (!conSched->getStatistics(this)) {
                StringList out;
                out += "in statistical information: ";
                if (conSched->dist.myParam()) 
			out += conSched->dist.myParam()->printParams();
                Error::abortRun(*this, out);
	}

	Target :: setup();
}

int CGDDFTarget :: computeProfile(int nP, int resWork, IntArray* avail) {
	conSched->setProcs(nP);
	conSched->copyProfile(profile+nP-1);
        // find optimal profile
	int fn = int(fixedNum);
	if (!fn) {
        	return conSched->calcProfile(resWork, avail);
	} else {
		conSched->fixProfile(fn, resWork, avail);
		return fn;
	}
}

void CGDDFTarget :: insideSchedule() {
	int numP = int(nprocs);
        GalStarIter next(*galaxy());
        Star* s;
        while ((s = next++) != 0) {
                if (s->isItWormhole()) {
                        CGDDFStar* wormStar = (CGDDFStar*) s;
                        CGDDFWormhole* worm = wormStar->myWormhole();
                        worm->setNumProcs(numP);
			/// turn the finalSchedule option on (-1).
                        worm->insideSchedule(numP,-1,0);
                }
        }
}

void CGDDFTarget :: downLoadCode(int ix, Profile* p) {
	conSched->downLoadCode(ix, child(curChild), p);
}

int CGDDFTarget :: totalWorkLoad() {
	return conSched->avgExecTime();
}

        //////////////////////////////
        // Display parallel schedules
        //////////////////////////////

StringList CGDDFTarget :: displaySchedule() {

        GalStarIter next(*galaxy());
        Star* s;

        StringList out;
        out += "\n(Inside CG domains of a dynamic)";
        out += " construct: ";
        out += "\n\n";

        // find out wormholes
        int i = 1;
        while ((s = next++) != 0) {
                if (s->isItWormhole()) {
                        CGDDFStar* wormStar = (CGDDFStar*) s;
                        CGDDFWormhole* worm = wormStar->myWormhole();
                        out += " \n <Worm ";
                        out += i;
                        out += ">\n\n";
                        out += worm->displaySchedule();
                        i++;
                }
        }
        return out;
}

DataFlowStar* CGDDFTarget::createReceive(int, int, int) {
	Error::abortRun(*this, "createReceive not implemented");
	return 0;
}
DataFlowStar* CGDDFTarget::createSend(int, int, int) {
	Error::abortRun(*this, "createSend not implemented");
	return 0;
}
DataFlowStar* CGDDFTarget::createSpread() {
	Error::abortRun(*this, "createReceive not implemented");
	return 0;
}
DataFlowStar* CGDDFTarget::createCollect() {
	Error::abortRun(*this, "createSend not implemented");
	return 0;
}

