/**************************************************************************
Version identification:
@(#)CGDDFPortHole.h	1.5	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Soonhoi Ha

This file contains definitions of CGDDF-specific PortHole classes.

******************************************************************/
#ifndef _CGDDFPortHole_h
#define _CGDDFPortHole_h 1
#ifdef __GNUG__
#pragma interface
#endif

#include "DDFPortHole.h"

/*****************************************************************
CGDDF: Code generation

These PortHoles are much like DDF PortHoles, from which they are derived.
****************************************************************/

        //////////////////////////////////////////
        // class CGDDFPortHole
        //////////////////////////////////////////

// Contains all the special features required for
//   dynamic dataflow (CGDDF)

class CGDDFPortHole : public DDFPortHole
{
	char* regClass;	// identifies the register class of the portHole
public:
	void setRegClass(char* className) {regClass = className; }

	// resolve abstraction.
	void moveData() {}

};

	///////////////////////////////////////////
	// class InCGDDFPort
	//////////////////////////////////////////

class InCGDDFPort : public CGDDFPortHole
{
public:
	int isItInput () const ; // {return TRUE; }

	// *****  CGDDF has no data on the portholes
	// void grabData();
};

	////////////////////////////////////////////
	// class OutCGDDFPort
	////////////////////////////////////////////

class OutCGDDFPort : public CGDDFPortHole
{
public:
        int isItOutput () const; // {return TRUE; }

	// void increment();
	// void grabData();
	// void sendData();
};

        //////////////////////////////////////////
        // class MultiCGDDFPort
        //////////////////////////////////////////
 
// Synchronous dataflow MultiPortHole for code generation
 
class MultiCGDDFPort : public MultiDDFPort {
	int memLoc;
public:
	void setMemLoc(int) { memLoc = 1;}

	// Services of MultiDDFPort that are used often:
	// setPort(const char* portName, Block* parent, dataType type,
	//	unsigned numTokens)
};

        //////////////////////////////////////////
        // class MultiInCGDDFPort
        //////////////////////////////////////////
        
// MultiInCGDDFPort is an CGDDF input MultiPortHole
 
class MultiInCGDDFPort : public MultiCGDDFPort {
public:
        int isItInput () const; // {return TRUE; }
 
        // Add a new physical port to the MultiPortHole list
        PortHole& newPort();
};
 
 
        //////////////////////////////////////////
        // class MultiOutCGDDFPort
        //////////////////////////////////////////

// MultiOutCGDDFPort is an CGDDF output MultiPortHole  

class MultiOutCGDDFPort : public MultiCGDDFPort {     
public:
        int isItOutput () const; // {return TRUE; }

        // Add a new physical port to the MultiPortHole list
        PortHole& newPort();
};

#endif
