static const char file_id[] = "CGDDFDomain.cc";

/**********************************************************************
Version identification:
@(#)CGDDFDomain.cc	1.4	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Soonhoi Ha
 Date of creation: 10/8/91

 A device to produce the correct portholes, wormholes, event horizons,
 etc, for the CGDDF domain so the interpreter can generate them dynamically.

***********************************************************************/

#include "Domain.h"
#include "CGDDFWormhole.h"
#include "CGDDFTarget.h"
#include "KnownTarget.h"
#include "CGDDFPortHole.h"
#include "CGDDFGeodesic.h"

extern const char CGDDFdomainName[] = "CGDDF";

class CGDDFDomain : public Domain {
public:

	// new wormhole
	Star& newWorm(Galaxy& innerGal, Target* tg)  {
		LOG_NEW; return *new CGDDFWormhole(innerGal, tg);
	}

	// new fromUniversal EventHorizon
	EventHorizon& newFrom() {
		LOG_NEW; return *new CGDDFfromUniversal;
	}

	// new toUniversal EventHorizon
	EventHorizon& newTo() {
		LOG_NEW; return *new CGDDFtoUniversal;
	}

	// new node (geodesic)
	Geodesic& newNode() { LOG_NEW; return *new CGDDFGeodesic;}

	// constructor
	CGDDFDomain() : Domain("CGDDF") {}
};

// declare a prototype
static CGDDFDomain proto;

// default CGDDFTarget
static CGDDFTarget defaultCGDDFTarget("default-CGDDF","CGDDFStar",
        "default CGDDF target");
static KnownTarget proto1(defaultCGDDFTarget,"default-CGDDF");


