#ifndef _CGConScheduler_h
#define _CGConScheduler_h 1
#ifdef __GNUG__
#pragma interface
#endif

#include "Scheduler.h"
#include "Galaxy.h"
#include "Profile.h"
#include "Distribution.h"

/**************************************************************************
Version identification:
@(#)CGConScheduler.h	1.6	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Soonhoi Ha

 Base class of the schedulers for dynamic constructs.
 The virtual methods in this class should be redefined in the derived
 classes.
 A topology of each construct is enforced so that no auto-wormholization
 is tried.

**************************************************************************/

class CGConScheduler : public Scheduler {
friend class CGDDFTarget;

public:
	CGConScheduler();
	~CGConScheduler();

	// my domain
	const char* domain() const;

	// set-up
	void setup(); 

	// virtual function to download the code
	virtual void downLoadCode(int, Target*, Profile*) {}

	// compute the profile with the given number of processors
	int calcProfile(int, IntArray*);
	// fix the number of processors assigned.
	void fixProfile(int, int, IntArray*);

	// copy the profile.
	void copyProfile(Profile* obj) { profile = obj; } 

	// set the number of processors
	void setProcs(int n);

	// read the statistical information on some parameters.
	virtual int getStatistics(Target*);

	// calculate the assumed execution time.
	int avgExecTime() 
		{ if (dist.myParam()) return assumeExecTime(); 
		  else		return 0; }

        // the following are do-nothing functions -- they may be
        // overridden by dynamic construct schedulers if needed
	int run();
	void setStopTime(double);
	double getStopTime() { return 0.0;}

protected:
	// calculate the assumed execution time.
	virtual int assumeExecTime();

	// execution profile of the dynamic construct
	Profile* profile;

	// number of the currently assigned processors.
	int numProcs;

	// Topology checking.
	virtual int examine(Galaxy& galaxy);

        DistBase dist;      // description of the parameter distribution.

	// Examine the topology more closely to check the more restricted
	// syntax.
	virtual int closerExamine();

	// Member initialization after topology checking if necessary.
	virtual void initMembers();

	// compute the quasi-static profile of the construct with a given
	// number of processors.
	virtual int setProfile(int, int, Profile*);

	// write the given code to the given target. We need to downcase
	// the target to CGTarget to do that.
	void addCode(Target* t, const char* code);

private:
	// temporal profiles
	Profile* temp1;
	Profile* temp2;
};

#endif
