static const char file_id[] = "CGConScheduler.cc";

#ifdef __GNUG__
#pragma implementation
#endif

#include "CGConScheduler.h"
#include "CGTarget.h"
#include "Galaxy.h"

extern int warnIfNotConnected (Galaxy&);
extern const char CGDDFdomainName[];

/**************************************************************************
Version identification:
@(#)CGConScheduler.cc	1.6	12/10/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Soonhoi Ha

 Methods for CGConScheduler class.
**************************************************************************/

		//////////////////
		//  constructor
		//////////////////

CGConScheduler :: CGConScheduler() {
	temp1 = new Profile;
	temp2 = new Profile;
}

CGConScheduler :: ~CGConScheduler() {
	delete temp1;
	delete temp2;
}

		//////////////////
		//   setup
		//////////////////

void CGConScheduler :: setup() {
	Galaxy& gal = *galaxy();
	// check connectivity
        if (warnIfNotConnected (gal)) {
                return;
        }

	// initialize galaxy.
        gal.initialize();

	// Topology checking
	// At the same time, the sequential quasi-static schedules are formed.
	if (!examine(gal)) return;

	if (!closerExamine()) return;

	// member initialization
	initMembers();
}

	
		//////////////////////
		//   setProcs
		//////////////////////

void CGConScheduler :: setProcs(int n) {

	numProcs = n;
	temp1->create(n);
	temp2->create(n);
}


		//////////////////////
		//   calcProfile
		//////////////////////

int CGConScheduler :: calcProfile(int resWork, IntArray* pAvail) {

	int flag = FALSE;
	IntArray* avail;
	if (!pAvail) {
		LOG_NEW; avail = new IntArray(numProcs);
		flag = TRUE;
	} else {
		avail = pAvail;
	}
	
        // temp profile initialize
        // If flip = 0, temp1 contains the optimal profile,
        // if flip = 1, temp2 contains the optimal profile.
        int flip = 0;
        temp1->initialize();

        int best = 1;   // Optimal number of the assigned processors to worm.
        setProfile(best, resWork, temp1);
        int idleCost = temp1->totalIdleTime(*avail, numProcs);
        double bestCost = temp1->getTotalCost();

        // If the residual work is so small that the other
        // processors can not be effectively used, increase the
        // cost of the profile by that extra idle time.
        if (idleCost > resWork) bestCost += idleCost - resWork;

        // find the minimum value of the profile cost and the number
        // of processors at that time.
        Profile* temp;          // profile pointer.
        for (int i = 1; i < numProcs; i++) {
                if (flip == 0)  temp = temp2;
                else            temp = temp1;
                temp->initialize();
                if (!setProfile(i+1, resWork, temp)) continue;
                double bCost = temp->getTotalCost();

                // if the cost is larger than the best cost, go next.
                if (bCost <= bestCost) {
                        int iCost = temp->totalIdleTime(*avail,numProcs)
                                    - resWork;
                        if (iCost > 0) bCost += iCost;
                        if (bCost < bestCost) {
                                best = i + 1;
                                bestCost = bCost;
                                if (!flip) flip = 1;
                                else       flip = 0;
                        }
                }
        }

        // Now copy the optimal profile.
        if (flip == 0)   temp = temp1;
        else            temp = temp2;
        Profile* store = profile;
        temp->copyIt(store);
        store->setEffP(temp->getEffP());       // store the optimal value N.
        store->setTotalCost(bestCost);

	// return optimal number of assigned processors.
	LOG_DEL; if (flag) delete avail;
	return best;
}

// virtual functions
int CGConScheduler :: getStatistics(Target*) { return FALSE; }
int CGConScheduler :: assumeExecTime() { return 0; }
int CGConScheduler :: examine(Galaxy&) { return FALSE; }
int CGConScheduler :: closerExamine() { return FALSE; }
int CGConScheduler :: setProfile(int, int, Profile*) { return 0; }

// do-nothing
int CGConScheduler :: run() { return TRUE; }
void CGConScheduler :: setStopTime(double) {}
void CGConScheduler :: initMembers()	{}

// my domain
const char* CGConScheduler :: domain() const { return CGDDFdomainName; }

		//////////////////////
		//   fixProfile
		//////////////////////

void CGConScheduler :: fixProfile(int nP, int resWork, IntArray* pAvail) {

	int flag = FALSE;
	int n = nP;
	IntArray* avail;
	if (!pAvail) {
		LOG_NEW; avail = new IntArray(numProcs);
		flag = TRUE;
	} else {
		avail = pAvail;
	}
	
        temp1->initialize();

        while (!setProfile(n, resWork, temp1)) n--;
        int idleCost = temp1->totalIdleTime(*avail, numProcs);
        double bestCost = temp1->getTotalCost();

        // If the residual work is so small that the other
        // processors can not be effectively used, increase the
        // cost of the profile by that extra idle time.
        if (idleCost > resWork) bestCost += idleCost - resWork;

        temp1->copyIt(profile);
        profile->setEffP(temp1->getEffP());    // store the optimal value N.
        profile->setTotalCost(bestCost);

	// return optimal number of assigned processors.
	LOG_DEL; if (flag) delete avail;
}

void CGConScheduler :: addCode(Target* t, const char* code) {
	CGTarget* ct = (CGTarget*) t;
	ct->getStream("code")->put(code);
}
