#ifndef ERRTRAP_H
#define ERRTRAP_H

#include "ansi.h"
#include <setjmp.h>

#define ERR_PKG_NAME	"errtrap"

EXTERN void errProgramName
	ARGS((char *progName));
EXTERN void errCore
	ARGS((int flag));
typedef void (*EH)
	ARGS((char *, int, char *));
EXTERN void errPushHandler
	ARGS((EH hndlr));
EXTERN void errPopHandler
	NULLARGS;
EXTERN void errRaise
	ARGS((char *pkgName, int code, char *format, ... ));
EXTERN void errPass
	ARGS((char *format, ... ));

#define ERR_IGNORE(expr)	\
    {					\
	if ( ! setjmp(errJmpBuf)) {	\
	    errIgnPush();		\
	    expr;			\
	}				\
	errIgnPop();			\
    }
extern jmp_buf errJmpBuf;
EXTERN void errIgnPush
	NULLARGS;
EXTERN void errIgnPop
	NULLARGS;
EXTERN int errStatus
	ARGS((char **pkgNamePtr, int *codePtr, char **messagePtr));

#endif /* ERRTRAP_H */
