;************************************************************************
;
;       EQUATES for DSP56000 I/O registers and ports
;
;************************************************************************
;

ioequlc ident   1,2

;------------------------------------------------------------------------
;
;       EQUATES for I/O Port Programming
;
;------------------------------------------------------------------------
;

;       Register Addresses
				
m_bcra	EQU	x:$FFFFFFFE	; Port A Bus Control Register
m_bcrb	EQU	x:$FFFFFFFD	; Port B Bus Control Register
m_psr	EQU	x:$FFFFFFFC	; Port Select Register

;------------------------------------------------------------------------
;
;       EQUATES for Host Interface
;
;------------------------------------------------------------------------

;       Register Addresses

m_htxa	EQU	x:$FFFFFFEF	; Host A HTX Register
m_hrxa	EQU	x:$FFFFFFEF	; Host A HRX Register (same as HTX Register)
m_htxca	EQU	x:$FFFFFFEE	; Host A HTX Reg. and HMRC Clear
m_hsra	EQU	x:$FFFFFFED	; Host A Status Register
m_hcra	EQU	x:$FFFFFFEC	; Host A Control Register

m_htxb	EQU	x:$FFFFFFE7	; Host B HTX Register
m_hrxb	EQU	x:$FFFFFFE7	; Host B HRX Register (same as HTX Register)
m_htxcb	EQU	x:$FFFFFFE6	; Host B HTX Reg. and HMRC Clear
m_hsrb	EQU	x:$FFFFFFE5	; Host B Status Register
m_hcrb	EQU	x:$FFFFFFE4	; Host B Control Register

;       Host Control Register Bit Flags

m_hrie	EQU	0		; HCR Host Receive Interrupt Enable
m_htie	EQU	1		; HCR Host Transmit Interrupt Enable
m_hcie	EQU	2		; HCR Host Commadn Interrupt Enable
m_hf2	EQU	3		; HCR Host Flag 2
m_hf3	EQU	4		; HCR Host Flag 3
m_hres	EQU	5		; HCR Host Reset
m_hpre	EQU	8		; HCR Host P Memory Read Interrupt Enable
m_hpwe	EQU	9		; HCR Host P Memory Write Interrupt Enable
m_hxre	EQU	10		; HCR Host X Memory Read Interrupt Enable
m_hxwe	EQU	11		; HCR Host X Memory Write Interrupt Enable
m_hyre	EQU	12		; HCR Host Y Memory Read Interrupt Enable
m_hywe	EQU	13		; HCR Host Y Memory Write Interrupt Enable

;       Host Status Register Bit Flags

m_hrdf	EQU	0		; HSR Host Receive Data Full
m_htde	EQU	1		; HSR Host Transmit Data Empty
m_hcp	EQU	2		; HSR Host Command Pending
m_hf0	EQU	3		; HSR Host Flag 0
m_hf1	EQU	4		; HSR Host Flag 1
m_hprp	EQU	8		; HSR Host P Memory Read Command Pending
m_hpwp	EQU	9		; HSR Host P Memory Write Command Pending
m_hxrp	EQU	10		; HSR Host X Memory Read Command Pending
m_hxwp	EQU	11		; HSR Host X Memory Write Command Pending
m_hyrp	EQU	12		; HSR Host Y Memory Read Command Pending
m_hywp	EQU	13		; HSR Host Y Memory Write Command Pending

;------------------------------------------------------------------------
;
;       EQUATES for DMA Interface
;
;------------------------------------------------------------------------

;       Register Addresses

m_dsm0	EQU	x:$fffffdf	; DMA Channel 0 Source Modifier Register
m_dsr0	EQU	x:$fffffde	; DMA Channel 0 Source Address Register
m_dsn0	EQU	x:$fffffdd	; DMA Channel 0 Source Offset Register
m_dco0	EQU	x:$fffffdc	; DMA Channel 0 Counter Register
m_ddm0	EQU	x:$fffffdb	; DMA Channel 0 Destination Modifier Register
m_ddr0	EQU	x:$fffffda	; DMA Channel 0 Destination Address Register
m_ddn0	EQU	x:$fffffd9	; DMA Channel 0 Destination Offset Register
m_dcs0	EQU	x:$ffffff8	; DMA Channel 0 Control/Status Register

m_dsm1	EQU	x:$fffffd7	; DMA Channel 1 Source Modifier Register
m_dsr1	EQU	x:$fffffd6	; DMA Channel 1 Source Address Register
m_dsn1	EQU	x:$fffffd5	; DMA Channel 1 Source Offset Register
m_dco1	EQU	x:$fffffd4	; DMA Channel 1 Counter Register
m_ddm1	EQU	x:$fffffd3	; DMA Channel 1 Destination Modifier Register
m_ddr1	EQU	x:$fffffd2	; DMA Channel 1 Destination Address Register
m_ddn1	EQU	x:$fffffd1	; DMA Channel 1 Destination Offset Register
m_dcs1	EQU	x:$ffffff0	; DMA Channel 1 Control/Status Register

;       DMA Control/Status Register Bit Flags

m_dds0	EQU	0		; DCS DMA Destination Space Control
m_dds1	EQU	1		; (Bits 0,1,2)
m_dds2	EQU	2		;
m_dss0	EQU	3		; DCS DMA Source Space Control
m_dss1	EQU	4		; (Bits 3,4,5)
m_dss2	EQU	5		;
				; Bits 8-14 - DCS DMA Request Masks
m_dcp	EQU	23		; DCS DMA Channel Priority
m_dmap	EQU	24		; DCS DMA Priority
m_dtm0	EQU	25		; DCS DMA Transfer Mode
m_dtm1	EQU	26		; (Bits 25,26)
m_dtd	EQU	28		; DCS DMA Transfer Done Status
m_die	EQU	30		; DCS CMA Interrupt Enable Control Bit
m_de	EQU	31		; DCS CMA Channel Enable Control Bit

;------------------------------------------------------------------------
;
;       EQUATES for Exception Processing
;
;------------------------------------------------------------------------

;       Register Addresses

m_ipr	EQU	x:$FFFFFFFF	; Interrupt Priority Register

;       Interrupt Priority Register Bit Flags

m_ial0	EQU	0		; IRQA Interrupt Priority Level
m_ial1	EQU	1		; (Bits 0-1)
m_ial2	EQU	2		; IRQA Trigger Mode
m_iras	EQU	3		; IRQA Status
m_ibl0	EQU	4		; IRQB Interrupt Priority Level
m_ibl1	EQU	5		; (Bits 4-5)
m_ibl2	EQU	6		; IRQB Trigger Mode
m_irbs	EQU	7		; IRQB Status
m_icl0	EQU	8		; IRQC Interrupt Priority Level
m_icl1	EQU	9		; (Bits 8-9)
m_icl2	EQU	10		; IRQC Trigger Mode
m_ircs	EQU	11		; IRQC Status
m_d0l0	EQU	16		; DMA Channel 0 Interrupt Priority Level
m_d0l1	EQU	17		; (Bits 16-17)
m_d1l0	EQU	18		; DMA Channel 1 Interrupt Priority Level
m_d1l1	EQU	19		; (Bits 18-19)
m_hal0	EQU	20		; Host A Interrupt Priority Level
m_hal1	EQU	21		; (Bits 20-21)
m_hbl0	EQU	22		; Host B Interrupt Priority Level
m_hbl1	EQU	23		; (Bits 22-23)
