.\" @(#)SDFperiodogram.t	1.1	12/17/92
.NA periodogram
.SD
Estimate a power spectrum using the periodogram method.
.DE
.LO "SDF dsp library (galaxy)"
.DM SDF SDFGalaxy
.SV 1.1 12/17/92
.AL "E. A. Lee"
.IH
.NE
\fIinput\fR (float)
.PE
.OH
.NE
\fIoutput\fR (float)
.PE
.SH
.NE
\fInumInputs\fR (int): The number of inputs to use to construct the estimate.
.DF "512"
.NE
\fIlog2order\fR (int): The log base 2 of the FFT order.
.DF "9"
.ET
.LD
This galaxy
estimates the power spectrum of its input using
the periodogram method.
.Ir "power spectrum"
.Ie "spectral estimation"
This consists simply of computing
the magnitude squared of the DFT
of a set of observations
of the signal.
.Ir "DFT"
The \fInumInputs\fR parameter specifies the number of observation samples
to collect.  The \fIlog2order\fR parameter gives the log base 2 of the FFT
order to use.  If $2 sup log2order$ is larger than \fInumInputs\fR,
then zero padding is done.
.pp
Prior to computing the spectrum, the signal is modulated with a signal
consisting of alternating + and - one, generated by the
.c WaveForm
star.  This signal shifts the d.c. component of the signal to the Nyquist
frequency, resulting in a spectrum that is centered.
Without this modulation, the d.c. component would be the first output
of the galaxy, and the last would be the component just below
the sampling frequency.
.UH "REFERENCES"
.ip [1]
S. M. Kay, \fIModern Spectral Estimation: Theory & Application\fR,
Prentice-Hall, Englewood Cliffs, NJ, 1988.
.SA
powerSpectrum
.ES
