.\" @(#)SDFautocorrelation.t	1.1	12/17/92
.NA autocorrelation
.SD
Estimate a power spectrum using the autocorrelation method.
.DE
.LO "SDF dsp library (galaxy)"
.DM SDF SDFGalaxy
.SV 1.1	12/17/92
.AL "E. A. Lee"
.IH
.NE
\fIinput\fR (float)
.PE
.OH
.NE
\fIoutput\fR (float)
.PE
.SH
.NE
\fInumInputs\fR (IntState): The number of inputs to use for the estimate.
.DF "512"
.NE
\fIorder\fR (IntState): The linear predictor order to use.
.DF "16"
.NE
\fIlog2resolution\fR (IntState): The log base 2 of the number of points in the frequency domain.
.DF "7"
.ET
.LD
.Ir "system identification"
.Ir "power spectrum"
This galaxy
estimates the power spectrum of its input using
the autocorrelation method
.Ir "autocorrelation method"
(which uses the Levinson Durbin algorithm).
.Ie "Levinson-Durbin algorithm"
If the input process is a Gaussian random process,
this method
produces an approximate \fImaximum entropy\fR spectral estimate.
.Ie "spectral estimation, maximum entropy"
.Ie "maximum entropy spectral estimation"
If the autocorrelation of the input process were known
exactly, then this methods would produce exact maximum entropy spectra.
However, the autocorrelation is estimated from observations
of the input using the
.c Autocor
star.
.Se "Autocor"
Per the classical technique,
a biased estimate is used (see references).
.Ir "biased autocorrelation"
Based on this autocorrelation estimate, the parameters of
an all-pole filter that could have produced the observations given
.Ir "allpole filter"
.Ir "filter, allpole"
a white noise input are estimated using the Levinson-Durbin algorithm.
The transfer function of the all-pole filter is:
.EQ
H(z) ~=~ 1 over {1 ~+~ sum from n=1 to N d sub n z sup -n }
.EN
The
.c LevDur
star outputs the $d sub n$ parameter estimates, also called the AR parameters.
.Se LevDur
The autocorrelation method power spectrum estimate is simply
.EQ
| H ( e sup {j omega } ) | sup 2
.EN
so the rest of the autocorrelation galaxy is devoted to computing
this quantity at various values of $omega$.  The number of values
of $omega$ to use (128, by default) is specified by the \fIresolution\fR
parameter of the galaxy.
The final output is scaled by an estimate of the power of the input
process, extracted from the autocorrelation estimate using the
.c Cut
star.
.Se Cut
The
.c Repeat
star is needed to maintain consistent sample rates.
.Se Repeat
The
.c FloatPad
star is used to prepend the first AR coefficient, which is always unity,
and hence need not be computed.
.Se FloatPad
.pp
Prior to computing the spectrum, the signal is modulated with a signal
consisting of alternating + and - one, generated by the
.c WaveForm
star.  This signal shifts the d.c. component of the signal to the Nyquist
frequency, resulting in a spectrum that is centered.
Without this modulation, the d.c. component would be the first output
of the galaxy, and the last would be the component just below
the sampling frequency.
.UH "REFERENCES"
.ip [1]
J. Makhoul, "Linear Prediction: A Tutorial Review",
\fIProc. IEEE\fR, Vol. 63, pp. 561-580, Apr. 1975.
.ip [2]
S. M. Kay, \fIModern Spectral Estimation: Theory & Application\fR,
Prentice-Hall, Englewood Cliffs, NJ, 1988.
.ip [3]
S. Haykin, \fIModern Filters\fR, MacMillan Publishing Company,
New York, 1989.
.SA
Burg,
LevDur,
levinsonDurbin,
linearPrediction.
.ES
