.\" documentation file generated from SDFWindow.pl by ptlang
.\" Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
.\" All rights reserved.
.\" See the file ~ptolemy/copyright for copyright notice,
.\" limitation of liability, and disclaimer of warranty provisions.
.NA "Window"
.SD
Generates standard window functions:
Rectangle, Hanning, Hamming, Blackman, and SteepBlackman.
.SE
.LO "SDF dsp library"
.DM SDF SDFStar
.SV 1.9 "12/8/92"
.AL "Kennard White"
.OH
.NE
\fIoutput\fR (float)
.PE
.SH
.NE
\fIname\fR (StringState): Name of the window function to generate.
.DF "Hanning"
.NE
\fIlength\fR (IntState): Length of the window function to produce.
.DF "256"
.NE
\fIperiod\fR (IntState): Period of the output. Period 0 implies "length" period, and
	  negative period is non-periodic (single cycle).
.DF "0"
.ET
.LD
.lp
This star produces on its output values that are samples of a standard
windowing function.  The window function to be sampled is determined by
the \fIname\fR string parameter.  Possible values are: \fBRectangle\fR,
\fBBartlett\fR, \fBHanning\fR, \fBHamming\fR, \fBBlackman\fR, and
\fBSteepBlackman\fR.  Upper and lower case characters in the names are
equivalent.
.lp
The parameter \fIlength\fR is the length of the window to produce.  Note
that most windows functions have zero value at the first and last sample.
The parameter \fIperiod\fR specifies the period of the output signal:
the window will be zero-padded if required.  A \fIperiod\fR of 0
means a period equal to \fIlength\fR.  A negative period will
produce only one window, and then outputs zero for all later samples.
A period of less than window length will be equivalent to a period of
window length (i.e, period=0).
.lp
One period of samples are produced on every firing.
.ES
